/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.rest.client.handler;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RegistryDateDeserializer
extends JsonDeserializer<Date> {
    private ThreadLocal<DateFormat> dateFormat = new ThreadLocal<DateFormat>(){

        @Override
        public DateFormat get() {
            return (DateFormat)super.get();
        }

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        }

        @Override
        public void remove() {
            super.remove();
        }

        @Override
        public void set(DateFormat value) {
            super.set(value);
        }
    };

    public Date deserialize(JsonParser parser, DeserializationContext context) throws IOException, JacksonException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        String date = node.textValue();
        if (date != null && date.endsWith("Z")) {
            date = date.replace("Z", "+0000");
        }
        try {
            return this.dateFormat.get().parse(date);
        }
        catch (ParseException parseException) {
            throw new JsonParseException(parser, "Failed to parse date (not a supported format).");
        }
    }
}

