/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.rest.client;

import io.apicurio.rest.client.auth.Auth;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.request.Request;
import io.apicurio.rest.client.response.ResponseHandler;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import io.apicurio.rest.client.util.ConcurrentUtil;
import io.apicurio.rest.client.util.IoUtil;
import io.apicurio.rest.client.util.UriUtil;
import io.vertx.core.Context;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.WebClient;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class VertxHttpClient
implements ApicurioHttpClient {
    private final WebClient webClient;
    private final Auth auth;
    private final String basePath;
    private final RestClientErrorHandler errorHandler;
    private static final Map<String, String> DEFAULT_HEADERS = new HashMap<String, String>();
    private static final ThreadLocal<Map<String, String>> requestHeaders = ThreadLocal.withInitial(Collections::emptyMap);

    public VertxHttpClient(Vertx vertx, String basePath, Map<String, Object> options, Auth auth, RestClientErrorHandler errorHandler) {
        if (!((String)basePath).endsWith("/")) {
            basePath = (String)basePath + "/";
        }
        this.webClient = WebClient.create((Vertx)vertx);
        this.auth = auth;
        this.basePath = basePath;
        this.errorHandler = errorHandler;
        VertxHttpClient.processConfiguration(options);
    }

    private static void processConfiguration(Map<String, Object> configs) {
        Map<String, String> requestHeaders = configs.entrySet().stream().filter(map -> ((String)map.getKey()).startsWith("apicurio.rest.request.headers.")).collect(Collectors.toMap(map -> ((String)map.getKey()).replace("apicurio.rest.request.headers.", ""), map -> map.getValue().toString()));
        if (!requestHeaders.isEmpty()) {
            DEFAULT_HEADERS.putAll(requestHeaders);
        }
    }

    public <T> T sendRequest(Request<T> request) {
        CompletableFuture<T> resultHolder;
        if (Context.isOnEventLoopThread()) {
            throw new UnsupportedOperationException("Must not be called on event loop");
        }
        URI uri = UriUtil.buildURI((String)(this.basePath + request.getRequestPath()), (Map)request.getQueryParams(), (List)request.getPathParams());
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setHost(uri.getHost());
        requestOptions.setURI(uri.getPath());
        requestOptions.setAbsoluteURI(uri.toString());
        DEFAULT_HEADERS.forEach((arg_0, arg_1) -> ((RequestOptions)requestOptions).addHeader(arg_0, arg_1));
        requestHeaders.get().forEach((arg_0, arg_1) -> ((RequestOptions)requestOptions).addHeader(arg_0, arg_1));
        requestHeaders.remove();
        HashMap<String, String> headers = request.getHeaders();
        if (this.auth != null) {
            headers = new HashMap<String, String>(headers);
            this.auth.apply(headers);
        }
        headers.forEach((arg_0, arg_1) -> ((RequestOptions)requestOptions).addHeader(arg_0, arg_1));
        String uriString = uri.toString();
        switch (request.getOperation()) {
            case GET: {
                resultHolder = this.executeGet(request, requestOptions.getHeaders(), uriString);
                break;
            }
            case PUT: {
                resultHolder = this.executePut(request, requestOptions.getHeaders(), uriString);
                break;
            }
            case POST: {
                resultHolder = this.executePost(request, requestOptions.getHeaders(), uriString);
                break;
            }
            case DELETE: {
                resultHolder = this.executeDelete(request, requestOptions.getHeaders(), uriString);
                break;
            }
            default: {
                throw new IllegalStateException("Operation not allowed");
            }
        }
        return (T)ConcurrentUtil.result(resultHolder);
    }

    private <T> CompletableFuture<T> executeGet(Request<T> request, MultiMap requestHeaders, String absoluteUri) {
        return this.sendRequestWithoutPayload(HttpMethod.GET, request, requestHeaders, absoluteUri);
    }

    private <T> CompletableFuture<T> executeDelete(Request<T> request, MultiMap requestHeaders, String absoluteUri) {
        return this.sendRequestWithoutPayload(HttpMethod.DELETE, request, requestHeaders, absoluteUri);
    }

    private <T> CompletableFuture<T> executePost(Request<T> request, MultiMap requestHeaders, String absoluteUri) {
        return this.sendRequestWithPayload(HttpMethod.POST, request, requestHeaders, absoluteUri);
    }

    private <T> CompletableFuture<T> executePut(Request<T> request, MultiMap requestHeaders, String absoluteUri) {
        return this.sendRequestWithPayload(HttpMethod.PUT, request, requestHeaders, absoluteUri);
    }

    private <T> CompletableFuture<T> sendRequestWithoutPayload(HttpMethod httpMethod, Request<T> request, MultiMap requestHeaders, String absoluteUri) {
        HttpRequest httpClientRequest = this.webClient.requestAbs(httpMethod, absoluteUri);
        httpClientRequest.putHeaders(requestHeaders);
        request.getQueryParams().forEach((key, paramList) -> paramList.forEach(value -> httpClientRequest.setQueryParam(key, value)));
        CompletableFuture resultHolder = new CompletableFuture();
        ResponseHandler responseHandler = new ResponseHandler(resultHolder, request.getResponseType(), this.errorHandler);
        httpClientRequest.send(responseHandler);
        return resultHolder;
    }

    private <T> CompletableFuture<T> sendRequestWithPayload(HttpMethod httpMethod, Request<T> request, MultiMap requestHeaders, String absoluteUri) {
        HttpRequest httpClientRequest = this.webClient.requestAbs(httpMethod, absoluteUri);
        httpClientRequest.putHeaders(requestHeaders);
        CompletableFuture resultHolder = new CompletableFuture();
        request.getQueryParams().forEach((key, paramList) -> paramList.forEach(value -> httpClientRequest.setQueryParam(key, value)));
        ResponseHandler responseHandler = new ResponseHandler(resultHolder, request.getResponseType(), this.errorHandler);
        Buffer buffer = request.getData() != null ? Buffer.buffer((byte[])IoUtil.toBytes((InputStream)request.getData())) : Buffer.buffer((byte[])IoUtil.toBytes((String)request.getDataString()));
        httpClientRequest.sendBuffer(buffer, responseHandler);
        return resultHolder;
    }

    public void setNextRequestHeaders(Map<String, String> headers) {
        requestHeaders.set(headers);
    }

    public Map<String, String> getHeaders() {
        return requestHeaders.get();
    }

    public void close() {
        this.webClient.close();
    }
}

