/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.Tag;
import java.util.ArrayList;

public class NewTagCommand
extends AbstractCommand {
    public String _tagName;
    public String _tagDescription;
    public boolean _created;

    NewTagCommand() {
    }

    NewTagCommand(String name, String description) {
        this._tagName = name;
        this._tagDescription = description;
    }

    @Override
    public void execute(Document document) {
        Tag tag;
        LoggerCompat.info("[NewTagCommand] Executing.", new Object[0]);
        this._created = false;
        if (this.isNullOrUndefined(document.tags)) {
            document.tags = new ArrayList<Tag>();
        }
        if (this.isNullOrUndefined(tag = this.findTag(document, this._tagName))) {
            document.addTag(this._tagName, this._tagDescription);
            this._created = true;
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewTagCommand] Reverting.", new Object[0]);
        if (!this._created) {
            return;
        }
        Tag tag = this.findTag(document, this._tagName);
        if (this.isNullOrUndefined(tag)) {
            return;
        }
        document.tags.remove(document.tags.indexOf(tag));
    }

    private Tag findTag(Document doc, String tagName) {
        for (Tag dt : doc.tags) {
            if (!NodeCompat.equals(dt.name, tagName)) continue;
            return dt;
        }
        return null;
    }
}

