/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import java.util.ArrayList;
import java.util.List;

public class RenamePathItemCommand
extends AbstractCommand {
    public String _oldPath;
    public String _newPath;
    public boolean _alsoRenameSubpaths;

    RenamePathItemCommand() {
    }

    RenamePathItemCommand(String oldPath, String newPath, boolean alsoRenameSubpaths) {
        this._oldPath = oldPath;
        this._newPath = newPath;
        this._alsoRenameSubpaths = alsoRenameSubpaths;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[RenamePathItemCommand] Executing.", new Object[0]);
        this._doPathRename(document, this._oldPath, this._newPath, this._alsoRenameSubpaths);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[RenamePathItemCommand] Reverting.", new Object[0]);
        this._doPathRename(document, this._newPath, this._oldPath, this._alsoRenameSubpaths);
    }

    private void _doPathRename(Document document, String from, String to, boolean alsoRenameSubpaths) {
        ArrayList<String[]> pathsToRename = new ArrayList<String[]>();
        pathsToRename.add(new String[]{from, to});
        OasDocument odoc = (OasDocument)document;
        if (this._alsoRenameSubpaths && ModelUtils.isDefined(odoc.paths)) {
            List<String> pathItemNames = odoc.paths.getPathItemNames();
            for (String pathName : pathItemNames) {
                if (pathName.indexOf(from) != 0 || NodeCompat.equals(pathName, from)) continue;
                pathsToRename.add(new String[]{pathName, to + pathName.substring(from.length())});
            }
        }
        pathsToRename.forEach(p2r -> this._renamePath(odoc, p2r[0], p2r[1]));
    }

    private void _renamePath(OasDocument document, String from, String to) {
        int idx;
        List<String> fromPathParamNames = ModelUtils.detectPathParamNames(from);
        List<String> toPathParamNames = ModelUtils.detectPathParamNames(to);
        if (fromPathParamNames.size() != toPathParamNames.size()) {
            LoggerCompat.warn("Renaming a path with %o parameters to a new value that has %o parameters!", fromPathParamNames.size(), toPathParamNames.size());
        }
        OasPathItem path = document.paths.removePathItem(from);
        path.rename(to);
        document.paths.addPathItem(to, path);
        for (idx = 0; idx < fromPathParamNames.size(); ++idx) {
            String fromParamName = fromPathParamNames.get(idx);
            String toParamName = null;
            if (idx < toPathParamNames.size()) {
                toParamName = toPathParamNames.get(idx);
            }
            if (ModelUtils.isDefined(toParamName)) {
                this._renamePathParameter(path, fromParamName, toParamName);
                continue;
            }
            this._removePathParameter(path, fromParamName);
        }
        if (toPathParamNames.size() > fromPathParamNames.size()) {
            for (idx = fromPathParamNames.size(); idx < toPathParamNames.size(); ++idx) {
                String paramName = toPathParamNames.get(idx);
                OasParameter parameter = path.createParameter();
                parameter.name = paramName;
                parameter.in = "path";
                parameter.required = true;
                path.addParameter(parameter);
            }
        }
    }

    private void _renamePathParameter(OasPathItem path, String fromParamName, String toParamName) {
        if (!NodeCompat.equals(fromParamName, toParamName) && ModelUtils.isDefined(path.parameters)) {
            path.parameters.forEach(param -> {
                if (NodeCompat.equals(param.in, "path") && NodeCompat.equals(param.name, fromParamName)) {
                    param.name = toParamName;
                }
            });
        }
    }

    private void _removePathParameter(OasPathItem path, String fromParamName) {
        if (this.isNullOrUndefined(path.parameters)) {
            return;
        }
        int paramIdx = -1;
        for (int idx = 0; idx < path.parameters.size(); ++idx) {
            OasParameter param = path.parameters.get(idx);
            if (!NodeCompat.equals(param.name, fromParamName) || !NodeCompat.equals(param.in, "path")) continue;
            paramIdx = idx;
        }
        if (paramIdx != -1) {
            path.parameters.remove(paramIdx);
        }
    }
}

