/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.combined.visitors.CombinedVisitorAdapter;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.core.util.VisitorUtil;
import io.apicurio.datamodels.core.visitors.TraverserDirection;
import io.apicurio.datamodels.openapi.models.IOasPropertySchema;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import java.util.ArrayList;
import java.util.List;

public abstract class RenameSchemaDefinitionCommand
extends AbstractCommand {
    public String _oldName;
    public String _newName;
    public List<NodePath> _references;

    RenameSchemaDefinitionCommand() {
    }

    RenameSchemaDefinitionCommand(String oldName, String newName) {
        this._oldName = oldName;
        this._newName = newName;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[RenameSchemaDefinitionCommand] Executing.", new Object[0]);
        this._references = new ArrayList<NodePath>();
        if (this._renameSchemaDefinition((OasDocument)document, this._oldName, this._newName)) {
            String oldRef = this._nameToReference(this._oldName);
            String newRef = this._nameToReference(this._newName);
            SchemaRefFinder schemaFinder = new SchemaRefFinder(oldRef);
            List<Schema> schemas = schemaFinder.findIn(document);
            for (Schema schema : schemas) {
                this._references.add(Library.createNodePath(schema));
                schema.$ref = newRef;
            }
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[RenameSchemaDefinitionCommand] Reverting.", new Object[0]);
        if (this._renameSchemaDefinition((OasDocument)document, this._newName, this._oldName)) {
            String oldRef = this._nameToReference(this._oldName);
            if (ModelUtils.isDefined(this._references)) {
                this._references.forEach(ref -> {
                    OasSchema schema = (OasSchema)ref.resolve(document);
                    schema.$ref = oldRef;
                });
            }
        }
    }

    protected abstract String _nameToReference(String var1);

    protected abstract boolean _renameSchemaDefinition(OasDocument var1, String var2, String var3);

    private static class SchemaRefFinder
    extends CombinedVisitorAdapter {
        private String _reference;
        private List<Schema> _schemas = new ArrayList<Schema>();

        public SchemaRefFinder(String reference) {
            this._reference = reference;
        }

        public List<Schema> findIn(Document document) {
            VisitorUtil.visitTree(document, this, TraverserDirection.down);
            return this._schemas;
        }

        protected boolean _accept(Schema schema) {
            return ModelUtils.isDefined(schema.$ref) && NodeCompat.equals(schema.$ref, this._reference);
        }

        protected void processSchema(Schema schema) {
            if (this._accept(schema)) {
                this._schemas.add(schema);
            }
        }

        @Override
        public void visitSchema(Schema node) {
            this.processSchema(node);
        }

        @Override
        public void visitSchemaDefinition(IDefinition node) {
            this.processSchema((Schema)((Object)node));
        }

        @Override
        public void visitPropertySchema(IOasPropertySchema node) {
            this.processSchema((Schema)((Object)node));
        }

        @Override
        public void visitAdditionalPropertiesSchema(OasSchema node) {
            this.processSchema(node);
        }

        @Override
        public void visitAllOfSchema(OasSchema node) {
            this.processSchema(node);
        }

        @Override
        public void visitItemsSchema(OasSchema node) {
            this.processSchema(node);
        }

        @Override
        public void visitAnyOfSchema(Oas30Schema.Oas30AnyOfSchema node) {
            this.processSchema(node);
        }

        @Override
        public void visitOneOfSchema(Oas30Schema.Oas30OneOfSchema node) {
            this.processSchema(node);
        }

        @Override
        public void visitNotSchema(Oas30Schema.Oas30NotSchema node) {
            this.processSchema(node);
        }
    }
}

