/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.models;

import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.IVisitable;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.ValidationProblem;
import io.apicurio.datamodels.core.models.ValidationProblemSeverity;
import io.apicurio.datamodels.core.visitors.IVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class Node
implements IVisitable {
    private static int __modelIdCounter = 0;
    public Document _ownerDocument;
    public Node _parent;
    protected int _modelId = __modelIdCounter++;
    protected Map<String, Object> _attributes;
    protected Map<String, Object> _extraProperties;
    protected Map<String, ValidationProblem> _validationProblems = new LinkedHashMap<String, ValidationProblem>();

    public Document ownerDocument() {
        return this._ownerDocument;
    }

    public boolean isExtensible() {
        return false;
    }

    public Node parent() {
        return this._parent;
    }

    public int modelId() {
        return this._modelId;
    }

    @Override
    public abstract void accept(IVisitor var1);

    public Object getAttribute(String attributeName) {
        if (this._attributes != null) {
            return this._attributes.get(attributeName);
        }
        return null;
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        if (this._attributes == null) {
            this._attributes = new HashMap<String, Object>();
        }
        this._attributes.put(attributeName, attributeValue);
    }

    public Collection<String> getAttributeNames() {
        if (this._attributes != null) {
            return this._attributes.keySet();
        }
        return Collections.emptyList();
    }

    public void clearAttributes() {
        if (this._attributes != null) {
            this._attributes.clear();
        }
    }

    public List<String> getValidationProblemCodes() {
        return new ArrayList<String>(this._validationProblems.keySet());
    }

    public List<ValidationProblem> getValidationProblems() {
        return new ArrayList<ValidationProblem>(this._validationProblems.values());
    }

    public List<ValidationProblem> getValidationProblemsFor(String propertyName) {
        ArrayList<ValidationProblem> rval = new ArrayList<ValidationProblem>();
        for (ValidationProblem problem : this._validationProblems.values()) {
            if (!problem.property.equals(propertyName)) continue;
            rval.add(problem);
        }
        return rval;
    }

    public ValidationProblem addValidationProblem(String errorCode, NodePath nodePath, String property, String message, ValidationProblemSeverity severity) {
        ValidationProblem problem = new ValidationProblem(errorCode, nodePath, property, message, severity);
        this._validationProblems.put(errorCode, problem);
        return problem;
    }

    public void clearValidationProblems() {
        this._validationProblems.clear();
    }

    public void addExtraProperty(String key, Object value) {
        if (this._extraProperties == null) {
            this._extraProperties = new LinkedHashMap<String, Object>();
        }
        this._extraProperties.put(key, value);
    }

    public Object removeExtraProperty(String name) {
        if (this._extraProperties != null && this._extraProperties.containsKey(name)) {
            return this._extraProperties.remove(name);
        }
        return null;
    }

    public boolean hasExtraProperties() {
        return this._extraProperties != null && this._extraProperties.size() > 0;
    }

    public List<String> getExtraPropertyNames() {
        if (this.hasExtraProperties()) {
            return new ArrayList<String>(this._extraProperties.keySet());
        }
        return Collections.emptyList();
    }

    public Object getExtraProperty(String name) {
        if (this.hasExtraProperties()) {
            return this._extraProperties.get(name);
        }
        return null;
    }
}

