/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.required;

import io.apicurio.datamodels.core.models.common.OAuthFlow;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.core.validation.rules.required.OasRequiredPropertyValidationRule;
import io.apicurio.datamodels.openapi.v3.models.Oas30AuthorizationCodeOAuthFlow;
import io.apicurio.datamodels.openapi.v3.models.Oas30ClientCredentialsOAuthFlow;
import io.apicurio.datamodels.openapi.v3.models.Oas30ImplicitOAuthFlow;
import io.apicurio.datamodels.openapi.v3.models.Oas30PasswordOAuthFlow;

public class OasMissingOAuthFlowScopesRule
extends OasRequiredPropertyValidationRule {
    public OasMissingOAuthFlowScopesRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private void visitOAuthFlow(OAuthFlow node) {
        this.requireProperty(node, "scopes", this.map(new String[0]));
    }

    @Override
    public void visitImplicitOAuthFlow(Oas30ImplicitOAuthFlow node) {
        this.visitOAuthFlow(node);
    }

    @Override
    public void visitPasswordOAuthFlow(Oas30PasswordOAuthFlow node) {
        this.visitOAuthFlow(node);
    }

    @Override
    public void visitClientCredentialsOAuthFlow(Oas30ClientCredentialsOAuthFlow node) {
        this.visitOAuthFlow(node);
    }

    @Override
    public void visitAuthorizationCodeOAuthFlow(Oas30AuthorizationCodeOAuthFlow node) {
        this.visitOAuthFlow(node);
    }
}

