/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.v3.io;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.Components;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.models.common.OAuthFlow;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.core.models.common.Server;
import io.apicurio.datamodels.core.models.common.ServerVariable;
import io.apicurio.datamodels.openapi.io.OasDataModelWriter;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.v3.models.Oas30AuthorizationCodeOAuthFlow;
import io.apicurio.datamodels.openapi.v3.models.Oas30Callback;
import io.apicurio.datamodels.openapi.v3.models.Oas30CallbackDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30CallbackPathItem;
import io.apicurio.datamodels.openapi.v3.models.Oas30ClientCredentialsOAuthFlow;
import io.apicurio.datamodels.openapi.v3.models.Oas30Discriminator;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Encoding;
import io.apicurio.datamodels.openapi.v3.models.Oas30Example;
import io.apicurio.datamodels.openapi.v3.models.Oas30ExampleDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Header;
import io.apicurio.datamodels.openapi.v3.models.Oas30HeaderDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30ImplicitOAuthFlow;
import io.apicurio.datamodels.openapi.v3.models.Oas30Link;
import io.apicurio.datamodels.openapi.v3.models.Oas30LinkDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30LinkParameterExpression;
import io.apicurio.datamodels.openapi.v3.models.Oas30LinkRequestBodyExpression;
import io.apicurio.datamodels.openapi.v3.models.Oas30LinkServer;
import io.apicurio.datamodels.openapi.v3.models.Oas30MediaType;
import io.apicurio.datamodels.openapi.v3.models.Oas30OAuthFlows;
import io.apicurio.datamodels.openapi.v3.models.Oas30Parameter;
import io.apicurio.datamodels.openapi.v3.models.Oas30PasswordOAuthFlow;
import io.apicurio.datamodels.openapi.v3.models.Oas30PathItem;
import io.apicurio.datamodels.openapi.v3.models.Oas30RequestBody;
import io.apicurio.datamodels.openapi.v3.models.Oas30RequestBodyDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Response;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import io.apicurio.datamodels.openapi.v3.models.Oas30SecurityScheme;
import io.apicurio.datamodels.openapi.v3.visitors.IOas30Visitor;

public class Oas30DataModelWriter
extends OasDataModelWriter
implements IOas30Visitor {
    @Override
    protected void writeDocument(Document node, Object json) {
        Oas30Document doc = (Oas30Document)node;
        JsonCompat.setPropertyString(json, "openapi", doc.openapi);
        JsonCompat.setPropertyNull(json, "info");
        JsonCompat.setPropertyNull(json, "servers");
        JsonCompat.setPropertyNull(json, "paths");
        JsonCompat.setPropertyNull(json, "components");
        JsonCompat.setPropertyNull(json, "security");
        JsonCompat.setPropertyNull(json, "tags");
        JsonCompat.setPropertyNull(json, "externalDocs");
        this.writeExtraProperties(json, node);
    }

    @Override
    protected void writeHeader(Object json, OasHeader node) {
        Oas30Header header = (Oas30Header)node;
        JsonCompat.setPropertyString(json, "$ref", header.$ref);
        JsonCompat.setPropertyBoolean(json, "required", header.required);
        JsonCompat.setPropertyBoolean(json, "deprecated", header.deprecated);
        JsonCompat.setPropertyBoolean(json, "allowEmptyValue", header.allowEmptyValue);
        JsonCompat.setPropertyString(json, "style", header.style);
        JsonCompat.setPropertyBoolean(json, "explode", header.explode);
        JsonCompat.setPropertyBoolean(json, "allowReserved", header.allowReserved);
        JsonCompat.setPropertyNull(json, "schema");
        JsonCompat.setProperty(json, "example", header.example);
        JsonCompat.setPropertyNull(json, "examples");
        JsonCompat.setPropertyNull(json, "content");
        super.writeHeader(json, node);
    }

    @Override
    protected void addHeaderToParent(Object parent, Object json, OasHeader node) {
        Object headers = JsonCompat.getProperty(parent, "headers");
        if (headers == null) {
            headers = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "headers", headers);
        }
        JsonCompat.setProperty(headers, node.getName(), json);
    }

    @Override
    protected void writeOperation(Object json, Operation node) {
        JsonCompat.setPropertyNull(json, "requestBody");
        JsonCompat.setPropertyNull(json, "callbacks");
        JsonCompat.setPropertyNull(json, "servers");
        super.writeOperation(json, node);
    }

    @Override
    protected void writePathItem(Object json, OasPathItem node) {
        Oas30PathItem pathItem = (Oas30PathItem)node;
        JsonCompat.setPropertyString(json, "summary", pathItem.summary);
        JsonCompat.setPropertyString(json, "description", pathItem.description);
        JsonCompat.setPropertyNull(json, "trace");
        JsonCompat.setPropertyNull(json, "servers");
        super.writePathItem(json, node);
    }

    @Override
    protected void writeParameter(Object json, Parameter node) {
        Oas30Parameter parameter = (Oas30Parameter)node;
        JsonCompat.setPropertyBoolean(json, "deprecated", parameter.deprecated);
        JsonCompat.setPropertyString(json, "style", parameter.style);
        JsonCompat.setPropertyBoolean(json, "explode", parameter.explode);
        JsonCompat.setPropertyBoolean(json, "allowReserved", parameter.allowReserved);
        JsonCompat.setProperty(json, "example", parameter.example);
        JsonCompat.setPropertyNull(json, "examples");
        JsonCompat.setPropertyNull(json, "content");
        super.writeParameter(json, node);
    }

    @Override
    protected void writeResponse(Object json, OasResponse node) {
        Oas30Response response = (Oas30Response)node;
        JsonCompat.setPropertyNull(json, "headers");
        JsonCompat.setPropertyNull(json, "content");
        JsonCompat.setPropertyNull(json, "links");
        super.writeResponse(json, response);
    }

    @Override
    protected void writeSchema(Object json, Schema node) {
        Oas30Schema schema = (Oas30Schema)node;
        JsonCompat.setPropertyNull(json, "oneOf");
        JsonCompat.setPropertyNull(json, "anyOf");
        JsonCompat.setPropertyNull(json, "not");
        JsonCompat.setPropertyNull(json, "discriminator");
        JsonCompat.setPropertyBoolean(json, "nullable", schema.nullable);
        JsonCompat.setPropertyBoolean(json, "writeOnly", schema.writeOnly);
        JsonCompat.setPropertyBoolean(json, "deprecated", schema.deprecated);
        super.writeSchema(json, node);
    }

    @Override
    protected void writeSecurityScheme(Object json, SecurityScheme node) {
        Oas30SecurityScheme schema = (Oas30SecurityScheme)node;
        JsonCompat.setPropertyString(json, "$ref", schema.$ref);
        JsonCompat.setPropertyString(json, "scheme", schema.scheme);
        JsonCompat.setPropertyString(json, "bearerFormat", schema.bearerFormat);
        JsonCompat.setPropertyNull(json, "flows");
        JsonCompat.setPropertyString(json, "openIdConnectUrl", schema.openIdConnectUrl);
        super.writeSecurityScheme(json, node);
    }

    @Override
    protected void addParameterDefinitionToParent(Object parent, Object json, IDefinition node) {
        Object parameters = JsonCompat.getProperty(parent, "parameters");
        if (parameters == null) {
            parameters = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "parameters", parameters);
        }
        JsonCompat.setProperty(parameters, node.getName(), json);
    }

    @Override
    public void visitComponents(Components node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        this.writeExtraProperties(json, node);
        JsonCompat.setProperty(parent, "components", json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitCallbackPathItem(Oas30CallbackPathItem node) {
        this.visitPathItem(node);
    }

    @Override
    public void visitCallback(Oas30Callback node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        this.writeCallback(json, node);
        this.writeExtraProperties(json, node);
        Object callbacks = JsonCompat.getProperty(parent, "callbacks");
        if (callbacks == null) {
            callbacks = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "callbacks", callbacks);
        }
        JsonCompat.setProperty(callbacks, node.getName(), json);
        this.updateIndex(node, json);
    }

    protected void writeCallback(Object json, Oas30Callback node) {
        JsonCompat.setPropertyString(json, "$ref", node.$ref);
    }

    @Override
    public void visitLinkServer(Oas30LinkServer node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyString(json, "url", node.url);
        JsonCompat.setPropertyString(json, "description", node.description);
        JsonCompat.setPropertyNull(json, "variables");
        this.writeExtraProperties(json, node);
        JsonCompat.setProperty(parent, "server", json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitCallbackDefinition(Oas30CallbackDefinition node) {
        this.visitCallback(node);
    }

    @Override
    public void visitLink(Oas30Link node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyString(json, "$ref", node.$ref);
        JsonCompat.setPropertyString(json, "operationRef", node.operationRef);
        JsonCompat.setPropertyString(json, "operationId", node.operationId);
        JsonCompat.setPropertyNull(json, "parameters");
        JsonCompat.setPropertyNull(json, "requestBody");
        JsonCompat.setPropertyString(json, "description", node.description);
        JsonCompat.setPropertyNull(json, "server");
        this.writeExtraProperties(json, node);
        Object links = JsonCompat.getProperty(parent, "links");
        if (links == null) {
            links = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "links", links);
        }
        JsonCompat.setProperty(links, node.getName(), json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitLinkRequestBodyExpression(Oas30LinkRequestBodyExpression node) {
        Object parent = this.lookupParentJson(node);
        JsonCompat.setPropertyString(parent, "requestBody", node.getValue());
    }

    @Override
    public void visitLinkParameterExpression(Oas30LinkParameterExpression node) {
        Object parent = this.lookupParentJson(node);
        Object parameters = JsonCompat.getProperty(parent, "parameters");
        if (parameters == null) {
            parameters = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "parameters", parameters);
        }
        JsonCompat.setPropertyString(parameters, node.getName(), node.getValue());
    }

    @Override
    public void visitLinkDefinition(Oas30LinkDefinition node) {
        this.visitLink(node);
    }

    @Override
    public void visitAuthorizationCodeOAuthFlow(Oas30AuthorizationCodeOAuthFlow node) {
        this.doVisitOAuthFlow(node, "authorizationCode");
    }

    @Override
    public void visitClientCredentialsOAuthFlow(Oas30ClientCredentialsOAuthFlow node) {
        this.doVisitOAuthFlow(node, "clientCredentials");
    }

    @Override
    public void visitPasswordOAuthFlow(Oas30PasswordOAuthFlow node) {
        this.doVisitOAuthFlow(node, "password");
    }

    @Override
    public void visitImplicitOAuthFlow(Oas30ImplicitOAuthFlow node) {
        this.doVisitOAuthFlow(node, "implicit");
    }

    protected void doVisitOAuthFlow(OAuthFlow node, String flowName) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyString(json, "authorizationUrl", node.authorizationUrl);
        JsonCompat.setPropertyString(json, "tokenUrl", node.tokenUrl);
        JsonCompat.setPropertyString(json, "refreshUrl", node.refreshUrl);
        JsonCompat.setProperty(json, "scopes", node.scopes);
        this.writeExtraProperties(json, node);
        JsonCompat.setProperty(parent, flowName, json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitOAuthFlows(Oas30OAuthFlows node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyNull(json, "implicit");
        JsonCompat.setPropertyNull(json, "password");
        JsonCompat.setPropertyNull(json, "clientCredentials");
        JsonCompat.setPropertyNull(json, "authorizationCode");
        this.writeExtraProperties(json, node);
        JsonCompat.setProperty(parent, "flows", json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitExample(Oas30Example node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyString(json, "$ref", node.$ref);
        JsonCompat.setPropertyString(json, "summary", node.summary);
        JsonCompat.setPropertyString(json, "description", node.description);
        JsonCompat.setProperty(json, "value", node.value);
        JsonCompat.setPropertyString(json, "externalValue", node.externalValue);
        this.writeExtraProperties(json, node);
        Object examples = JsonCompat.getProperty(parent, "examples");
        if (examples == null) {
            examples = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "examples", examples);
        }
        JsonCompat.setProperty(examples, node.getName(), json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitEncoding(Oas30Encoding node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyString(json, "contentType", node.contentType);
        JsonCompat.setPropertyNull(json, "headers");
        JsonCompat.setPropertyString(json, "style", node.style);
        JsonCompat.setPropertyBoolean(json, "explode", node.explode);
        JsonCompat.setPropertyBoolean(json, "allowReserved", node.allowReserved);
        this.writeExtraProperties(json, node);
        Object encoding = JsonCompat.getProperty(parent, "encoding");
        if (encoding == null) {
            encoding = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "encoding", encoding);
        }
        JsonCompat.setProperty(encoding, node.getName(), json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitMediaType(Oas30MediaType node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyNull(json, "schema");
        JsonCompat.setProperty(json, "example", node.example);
        JsonCompat.setPropertyNull(json, "examples");
        JsonCompat.setPropertyNull(json, "encoding");
        this.writeExtraProperties(json, node);
        Object content = JsonCompat.getProperty(parent, "content");
        if (content == null) {
            content = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "content", content);
        }
        JsonCompat.setProperty(content, node.getName(), json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitHeaderDefinition(Oas30HeaderDefinition node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        this.writeHeader(json, node);
        this.writeExtraProperties(json, node);
        Object headers = JsonCompat.getProperty(parent, "headers");
        if (headers == null) {
            headers = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "headers", headers);
        }
        JsonCompat.setProperty(headers, node.getName(), json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitRequestBody(Oas30RequestBody node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        this.writeRequestBody(json, node);
        this.writeExtraProperties(json, node);
        JsonCompat.setProperty(parent, "requestBody", json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitRequestBodyDefinition(Oas30RequestBodyDefinition node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        this.writeRequestBody(json, node);
        this.writeExtraProperties(json, node);
        Object requestBodies = JsonCompat.getProperty(parent, "requestBodies");
        if (requestBodies == null) {
            requestBodies = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "requestBodies", requestBodies);
        }
        JsonCompat.setProperty(requestBodies, node.getName(), json);
        this.updateIndex(node, json);
    }

    protected void writeRequestBody(Object json, Oas30RequestBody node) {
        JsonCompat.setPropertyString(json, "$ref", node.$ref);
        JsonCompat.setPropertyString(json, "description", node.description);
        JsonCompat.setPropertyNull(json, "content");
        JsonCompat.setPropertyBoolean(json, "required", node.required);
    }

    @Override
    public void visitExampleDefinition(Oas30ExampleDefinition node) {
        this.visitExample(node);
    }

    @Override
    public void visitDiscriminator(Oas30Discriminator node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyString(json, "propertyName", node.propertyName);
        JsonCompat.setProperty(json, "mapping", node.mapping);
        this.writeExtraProperties(json, node);
        JsonCompat.setProperty(parent, "discriminator", json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitNotSchema(Oas30Schema.Oas30NotSchema node) {
        this.doVisitSchema(node, "not", false);
    }

    @Override
    public void visitOneOfSchema(Oas30Schema.Oas30OneOfSchema node) {
        this.doVisitSchema(node, "oneOf", true);
    }

    @Override
    public void visitAnyOfSchema(Oas30Schema.Oas30AnyOfSchema node) {
        this.doVisitSchema(node, "anyOf", true);
    }

    @Override
    protected void addSchemaDefinitionToParent(Object parent, Object json, IDefinition node) {
        Object schemas = JsonCompat.getProperty(parent, "schemas");
        if (schemas == null) {
            schemas = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "schemas", schemas);
        }
        JsonCompat.setProperty(schemas, node.getName(), json);
    }

    @Override
    protected void addResponseDefinitionToParent(Object parent, Object json, IDefinition node) {
        Object responses = JsonCompat.getProperty(parent, "responses");
        if (responses == null) {
            responses = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "responses", responses);
        }
        JsonCompat.setProperty(responses, node.getName(), json);
    }

    @Override
    protected void addSecuritySchemeToParent(Object parent, Object json, SecurityScheme node) {
        Object securitySchemes = JsonCompat.getProperty(parent, "securitySchemes");
        if (securitySchemes == null) {
            securitySchemes = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "securitySchemes", securitySchemes);
        }
        JsonCompat.setProperty(securitySchemes, node.getSchemeName(), json);
    }

    @Override
    public void visitServer(Server node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        this.writeServer(json, node);
        this.writeExtraProperties(json, node);
        JsonCompat.appendToArrayProperty(parent, "servers", json);
        this.updateIndex(node, json);
    }

    protected void writeServer(Object json, Server node) {
        JsonCompat.setPropertyString(json, "url", node.url);
        JsonCompat.setPropertyString(json, "description", node.description);
        JsonCompat.setPropertyNull(json, "variables");
    }

    @Override
    public void visitServerVariable(ServerVariable node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        this.writeServerVariable(json, node);
        this.writeExtraProperties(json, node);
        Object variables = JsonCompat.getProperty(parent, "variables");
        if (variables == null) {
            variables = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "variables", variables);
        }
        JsonCompat.setProperty(variables, node.getName(), json);
        this.updateIndex(node, json);
    }

    protected void writeServerVariable(Object json, ServerVariable node) {
        JsonCompat.setPropertyStringArray(json, "enum", node.enum_);
        JsonCompat.setPropertyString(json, "default", node.default_);
        JsonCompat.setPropertyString(json, "description", node.description);
        JsonCompat.setPropertyNull(json, "variables");
    }
}

