/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Document;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.core.factories.DocumentFactory;
import io.apicurio.datamodels.core.factories.VisitorFactory;
import io.apicurio.datamodels.core.io.DataModelReader;
import io.apicurio.datamodels.core.io.DataModelReaderDispatcher;
import io.apicurio.datamodels.core.io.DataModelWriter;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.DocumentType;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.ValidationProblem;
import io.apicurio.datamodels.core.util.IReferenceResolver;
import io.apicurio.datamodels.core.util.NodePathUtil;
import io.apicurio.datamodels.core.util.ReferenceResolverChain;
import io.apicurio.datamodels.core.util.VisitorUtil;
import io.apicurio.datamodels.core.validation.DefaultSeverityRegistry;
import io.apicurio.datamodels.core.validation.IValidationSeverityRegistry;
import io.apicurio.datamodels.core.validation.ValidationProblemsResetVisitor;
import io.apicurio.datamodels.core.validation.ValidationVisitor;
import io.apicurio.datamodels.core.visitors.IVisitor;
import io.apicurio.datamodels.core.visitors.TraverserDirection;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.visitors.dereference.Dereferencer;
import io.apicurio.datamodels.openapi.visitors.transform.Oas20to30TransformationVisitor;
import java.util.List;

public class Library {
    public static void addReferenceResolver(IReferenceResolver resolver) {
        ReferenceResolverChain.getInstance().addResolver(resolver);
    }

    public static void removeReferenceResolver(IReferenceResolver resolver) {
        ReferenceResolverChain.getInstance().removeResolver(resolver);
    }

    public static Document createDocument(DocumentType type) {
        switch (type) {
            case asyncapi2: {
                return new Aai20Document();
            }
            case openapi2: {
                return new Oas20Document();
            }
            case openapi3: {
                return new Oas30Document();
            }
        }
        throw new RuntimeException("Unknown document type: " + (Object)((Object)type));
    }

    public static NodePath createNodePath(Node node) {
        return NodePathUtil.createNodePath(node);
    }

    public static void visitNode(Node node, IVisitor visitor) {
        VisitorUtil.visitNode(node, visitor);
    }

    public static void visitTree(Node node, IVisitor visitor, TraverserDirection direction) {
        VisitorUtil.visitTree(node, visitor, direction);
    }

    public static List<ValidationProblem> validate(Node node, IValidationSeverityRegistry severityRegistry) {
        if (severityRegistry == null) {
            severityRegistry = new DefaultSeverityRegistry();
        }
        ValidationProblemsResetVisitor resetter = VisitorFactory.createValidationProblemsResetVisitor(node.ownerDocument());
        Library.visitTree(node, resetter, TraverserDirection.down);
        ValidationVisitor validator = VisitorFactory.createValidationVisitor(node.ownerDocument());
        validator.setSeverityRegistry(severityRegistry);
        Library.visitTree(node, validator, TraverserDirection.down);
        return validator.getValidationProblems();
    }

    public static Document readDocument(Object json) {
        JsonNode clonedJson = JsonCompat.clone(json);
        DocumentType type = Library.discoverDocumentType(clonedJson);
        DataModelReader reader = VisitorFactory.createDataModelReader(type);
        Document document = DocumentFactory.create(type);
        reader.readDocument(clonedJson, document);
        return document;
    }

    public static Document readDocumentFromJSONString(String jsonString) {
        Object json = JsonCompat.parseJSON(jsonString);
        return Library.readDocument(json);
    }

    public static Node readNode(Object json, Node node) {
        JsonNode clonedJson = JsonCompat.clone(json);
        DocumentType type = node.ownerDocument().getDocumentType();
        DataModelReader reader = VisitorFactory.createDataModelReader(type);
        DataModelReaderDispatcher dispatcher = VisitorFactory.createDataModelReaderDispatcher(type, clonedJson, reader);
        Library.visitNode(node, dispatcher);
        return node;
    }

    public static Object writeNode(Node node) {
        DataModelWriter writer = VisitorFactory.createDataModelWriter(node.ownerDocument());
        Library.visitTree(node, writer, TraverserDirection.down);
        return writer.getResult();
    }

    public static String writeDocumentToJSONString(Document document) {
        Object json = Library.writeNode(document);
        return JsonCompat.stringify(json);
    }

    public static DocumentType discoverDocumentType(Object json) {
        String asyncapi = JsonCompat.getPropertyString(json, "asyncapi");
        String openapi = JsonCompat.getPropertyString(json, "openapi");
        String swagger = JsonCompat.getPropertyString(json, "swagger");
        if (asyncapi != null && asyncapi.startsWith("2.")) {
            return DocumentType.asyncapi2;
        }
        if (openapi != null) {
            if (openapi.startsWith("2.")) {
                return DocumentType.openapi2;
            }
            if (openapi.startsWith("3.0")) {
                return DocumentType.openapi3;
            }
        }
        if (swagger != null && swagger.startsWith("2.")) {
            return DocumentType.openapi2;
        }
        throw new RuntimeException("Unknown data model type or version.");
    }

    public static Document cloneDocument(Document source) {
        Object jsObj = Library.writeNode(source);
        return Library.readDocument(jsObj);
    }

    public static Oas30Document transformDocument(Oas20Document source) {
        Oas20Document clone = (Oas20Document)Library.cloneDocument(source);
        Oas20to30TransformationVisitor transformer = new Oas20to30TransformationVisitor();
        VisitorUtil.visitTree(clone, transformer, TraverserDirection.down);
        return transformer.getResult();
    }

    public static Document dereferenceDocument(Document source) {
        Dereferencer rl = new Dereferencer(source);
        return rl.dereference();
    }
}

