/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;

public class ChangePropertyCommand<T>
extends AbstractCommand {
    public NodePath _nodePath;
    public String _property;
    public T _newValue;
    public T _oldValue;

    ChangePropertyCommand() {
    }

    ChangePropertyCommand(Node node, String property, T newValue) {
        if (ModelUtils.isDefined(node)) {
            this._nodePath = Library.createNodePath(node);
        }
        this._property = property;
        this._newValue = newValue;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[ChangePropertyCommand] Executing.", new Object[0]);
        Node node = this._nodePath.resolve(document);
        if (this.isNullOrUndefined(node)) {
            return;
        }
        this._oldValue = NodeCompat.getProperty(node, this._property);
        NodeCompat.setProperty(node, this._property, this._newValue);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ChangePropertyCommand] Reverting.", new Object[0]);
        Node node = this._nodePath.resolve(document);
        if (this.isNullOrUndefined(node)) {
            return;
        }
        NodeCompat.setProperty(node, this._property, this._oldValue);
        this._oldValue = null;
    }
}

