/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiMessage;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Message;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;

public class AddOneOfInMessageCommand
extends AbstractCommand {
    public NodePath _parentPath;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _newOneOf;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldMessage;

    AddOneOfInMessageCommand() {
    }

    AddOneOfInMessageCommand(AaiMessage message) {
        this._parentPath = Library.createNodePath(message);
        this._newOneOf = message;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[AddOneOfInMessageCommand] Executing.", new Object[0]);
        AaiMessage parent = (AaiMessage)this._parentPath.resolve(document);
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        this._oldMessage = Library.writeNode(parent);
        Aai20Message message = new Aai20Message(parent, null);
        message.setIsOneOfMessage(true);
        Library.readNode(this._newOneOf, message);
        parent.addOneOfMessage(message, null);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[AddOneOfInMessageCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldMessage)) {
            return;
        }
        AaiMessage parentMessage = (AaiMessage)this._parentPath.resolve(document);
        if (this.isNullOrUndefined(parentMessage)) {
            return;
        }
        NodeCompat.setProperty(parentMessage.parent(), "message", parentMessage);
        parentMessage.oneOf = null;
        Library.readNode(this._oldMessage, parentMessage);
    }
}

