/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;

public class ChangeContactCommand
extends AbstractCommand {
    public String _newName;
    public String _newEmail;
    public String _newUrl;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldContact;
    public boolean _nullInfo;

    ChangeContactCommand() {
    }

    ChangeContactCommand(String name, String email, String url) {
        this._newName = name;
        this._newEmail = email;
        this._newUrl = url;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[ChangeContactCommand] Executing.", new Object[0]);
        this._oldContact = null;
        this._nullInfo = false;
        if (this.isNullOrUndefined(document.info)) {
            this._nullInfo = true;
            document.info = document.createInfo();
            this._oldContact = null;
        } else {
            this._oldContact = null;
            if (ModelUtils.isDefined(document.info.contact)) {
                this._oldContact = Library.writeNode(document.info.contact);
            }
        }
        document.info.contact = document.info.createContact();
        document.info.contact.name = this._newName;
        document.info.contact.url = this._newUrl;
        document.info.contact.email = this._newEmail;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ChangeContactCommand] Reverting.", new Object[0]);
        if (this._nullInfo) {
            document.info = null;
        } else if (ModelUtils.isDefined(this._oldContact)) {
            document.info.contact = document.info.createContact();
            Library.readNode(this._oldContact, document.info.contact);
        } else {
            document.info.contact = null;
        }
    }
}

