/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.IOasParameterParent;
import io.apicurio.datamodels.openapi.models.OasParameter;
import java.util.ArrayList;
import java.util.List;

public class DeleteParameterCommand
extends AbstractCommand {
    public NodePath _parameterPath;
    public NodePath _parentPath;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldParameter;

    DeleteParameterCommand() {
    }

    DeleteParameterCommand(OasParameter parameter) {
        this._parameterPath = Library.createNodePath(parameter);
        this._parentPath = Library.createNodePath(parameter.parent());
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteParameterCommand] Executing.", new Object[0]);
        this._oldParameter = null;
        OasParameter param = (OasParameter)this._parameterPath.resolve(document);
        if (this.isNullOrUndefined(param)) {
            return;
        }
        IOasParameterParent parent = (IOasParameterParent)((Object)param.parent());
        List<OasParameter> parameters = parent.getParameters();
        int idx = parameters.indexOf(param);
        if (idx == -1) {
            return;
        }
        parameters.remove(idx);
        this._oldParameter = Library.writeNode(param);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteParameterCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldParameter)) {
            return;
        }
        IOasParameterParent parent = (IOasParameterParent)((Object)this._parentPath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        List<OasParameter> parameters = parent.getParameters();
        if (this.isNullOrUndefined(parameters)) {
            parameters = new ArrayList<OasParameter>();
            NodeCompat.setProperty(parent, "parameters", parameters);
        }
        OasParameter param = parent.createParameter();
        Library.readNode(this._oldParameter, param);
        parent.addParameter(param);
    }
}

