/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation;

import io.apicurio.datamodels.combined.visitors.CombinedCompositeVisitor;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.ValidationProblem;
import io.apicurio.datamodels.core.models.ValidationProblemSeverity;
import io.apicurio.datamodels.core.util.NodePathUtil;
import io.apicurio.datamodels.core.validation.IValidationProblemReporter;
import io.apicurio.datamodels.core.validation.IValidationSeverityRegistry;
import io.apicurio.datamodels.core.validation.ValidationRule;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.core.validation.ValidationRuleSet;
import io.apicurio.datamodels.core.visitors.IVisitor;
import java.util.ArrayList;
import java.util.List;

public class ValidationVisitor
extends CombinedCompositeVisitor
implements IValidationProblemReporter {
    private List<ValidationProblem> problems = new ArrayList<ValidationProblem>();
    private IValidationSeverityRegistry severityRegistry;

    public ValidationVisitor(Document document) {
        super(new ArrayList<IVisitor>());
        ValidationRuleSet ruleSet = ValidationRuleSet.instance;
        List<ValidationRule> rulesFor = ruleSet.getRulesFor(document);
        rulesFor.forEach(rule -> rule.setReporter(this));
        this.addVisitors(rulesFor);
    }

    public void setSeverityRegistry(IValidationSeverityRegistry severityRegistry) {
        this.severityRegistry = severityRegistry;
    }

    public List<ValidationProblem> getValidationProblems() {
        return this.problems;
    }

    @Override
    public void report(ValidationRuleMetaData ruleInfo, Node node, String property, String message) {
        ValidationProblemSeverity severity = this.severityRegistry.lookupSeverity(ruleInfo);
        if (severity == ValidationProblemSeverity.ignore) {
            return;
        }
        NodePath path = NodePathUtil.createNodePath(node);
        ValidationProblem problem = node.addValidationProblem(ruleInfo.code, path, property, message, severity);
        this.problems.add(problem);
    }
}

