/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.asyncapi.io;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.asyncapi.models.AaiChannelBindings;
import io.apicurio.datamodels.asyncapi.models.AaiChannelBindingsDefinition;
import io.apicurio.datamodels.asyncapi.models.AaiChannelItem;
import io.apicurio.datamodels.asyncapi.models.AaiComponents;
import io.apicurio.datamodels.asyncapi.models.AaiCorrelationId;
import io.apicurio.datamodels.asyncapi.models.AaiDocument;
import io.apicurio.datamodels.asyncapi.models.AaiHeaderItem;
import io.apicurio.datamodels.asyncapi.models.AaiMessage;
import io.apicurio.datamodels.asyncapi.models.AaiMessageBase;
import io.apicurio.datamodels.asyncapi.models.AaiMessageBindings;
import io.apicurio.datamodels.asyncapi.models.AaiMessageBindingsDefinition;
import io.apicurio.datamodels.asyncapi.models.AaiMessageTrait;
import io.apicurio.datamodels.asyncapi.models.AaiMessageTraitDefinition;
import io.apicurio.datamodels.asyncapi.models.AaiOperation;
import io.apicurio.datamodels.asyncapi.models.AaiOperationBase;
import io.apicurio.datamodels.asyncapi.models.AaiOperationBindings;
import io.apicurio.datamodels.asyncapi.models.AaiOperationBindingsDefinition;
import io.apicurio.datamodels.asyncapi.models.AaiOperationTrait;
import io.apicurio.datamodels.asyncapi.models.AaiOperationTraitDefinition;
import io.apicurio.datamodels.asyncapi.models.AaiParameter;
import io.apicurio.datamodels.asyncapi.models.AaiSecurityScheme;
import io.apicurio.datamodels.asyncapi.models.AaiServer;
import io.apicurio.datamodels.asyncapi.models.AaiServerBindings;
import io.apicurio.datamodels.asyncapi.models.AaiServerBindingsDefinition;
import io.apicurio.datamodels.asyncapi.models.AaiServerVariable;
import io.apicurio.datamodels.asyncapi.visitors.IAaiVisitor;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.core.io.DataModelWriter;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.AuthorizationCodeOAuthFlow;
import io.apicurio.datamodels.core.models.common.ClientCredentialsOAuthFlow;
import io.apicurio.datamodels.core.models.common.Components;
import io.apicurio.datamodels.core.models.common.ImplicitOAuthFlow;
import io.apicurio.datamodels.core.models.common.OAuthFlow;
import io.apicurio.datamodels.core.models.common.OAuthFlows;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.PasswordOAuthFlow;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.core.models.common.Server;
import io.apicurio.datamodels.core.models.common.ServerVariable;
import java.util.Map;

public abstract class AaiDataModelWriter
extends DataModelWriter
implements IAaiVisitor {
    @Override
    protected void writeDocument(Document node, Object json) {
        AaiDocument aaiNode = (AaiDocument)node;
        JsonCompat.setPropertyString(json, "asyncapi", aaiNode.asyncapi);
        JsonCompat.setPropertyString(json, "id", aaiNode.id);
        JsonCompat.setPropertyString(json, "defaultContentType", aaiNode.defaultContentType);
        JsonCompat.setPropertyNull(json, "info");
        JsonCompat.setPropertyNull(json, "servers");
        JsonCompat.setPropertyNull(json, "channels");
        JsonCompat.setPropertyNull(json, "components");
        JsonCompat.setPropertyNull(json, "tags");
        JsonCompat.setPropertyNull(json, "externalDocs");
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    public void visitServer(Server node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        this.writeServer(json, node);
        Object servers = JsonCompat.getProperty(parent, "servers");
        if (servers == null) {
            servers = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "servers", servers);
        }
        JsonCompat.setProperty(servers, ((AaiServer)node).getName(), json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    protected void writeServer(Object json, Server node) {
        JsonCompat.setPropertyString(json, "url", node.url);
        JsonCompat.setPropertyString(json, "description", node.description);
        JsonCompat.setPropertyNull(json, "variables");
        AaiServer server = (AaiServer)node;
        JsonCompat.setPropertyString(json, "protocol", server.protocol);
        JsonCompat.setPropertyString(json, "protocolVersion", server.protocolVersion);
        JsonCompat.setPropertyNull(json, "security");
        JsonCompat.setPropertyNull(json, "bindings");
    }

    @Override
    public void visitServerVariable(ServerVariable node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        this.writeServerVariable(json, node);
        this.writeExtraProperties(json, node);
        Object variables = JsonCompat.getProperty(parent, "variables");
        if (variables == null) {
            variables = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "variables", variables);
        }
        JsonCompat.setProperty(variables, node.getName(), json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    protected void writeServerVariable(Object json, ServerVariable node) {
        JsonCompat.setPropertyStringArray(json, "enum", node.enum_);
        JsonCompat.setPropertyString(json, "default", node.default_);
        JsonCompat.setPropertyString(json, "description", node.description);
        JsonCompat.setPropertyNull(json, "variables");
        AaiServerVariable serverVar = (AaiServerVariable)node;
        JsonCompat.setPropertyStringArray(json, "examples", serverVar.examples);
    }

    @Override
    public void visitAuthorizationCodeOAuthFlow(AuthorizationCodeOAuthFlow node) {
        this.doVisitOAuthFlow(node, "authorizationCode");
    }

    @Override
    public void visitChannelItem(AaiChannelItem node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyString(json, "$ref", node.$ref);
        JsonCompat.setPropertyString(json, "description", node.description);
        JsonCompat.setPropertyNull(json, "publish");
        JsonCompat.setPropertyNull(json, "subscribe");
        JsonCompat.setPropertyNull(json, "parameters");
        JsonCompat.setPropertyNull(json, "bindings");
        Object map = JsonCompat.getProperty(parent, "channels");
        if (map == null) {
            map = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "channels", map);
        }
        JsonCompat.setProperty(map, node.getName(), json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    public void visitClientCredentialsOAuthFlow(ClientCredentialsOAuthFlow node) {
        this.doVisitOAuthFlow(node, "clientCredentials");
    }

    @Override
    public void visitComponents(Components node) {
        AaiComponents components = (AaiComponents)node;
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        ObjectNode schemas = JsonCompat.objectNode();
        if (components.schemas != null) {
            for (Map.Entry<String, Object> e : components.schemas.entrySet()) {
                JsonCompat.setProperty(schemas, e.getKey(), e.getValue());
            }
            JsonCompat.setProperty(json, "schemas", schemas);
        }
        JsonCompat.setPropertyNull(json, "messages");
        JsonCompat.setPropertyNull(json, "securitySchemes");
        JsonCompat.setPropertyNull(json, "parameters");
        JsonCompat.setPropertyNull(json, "correlationIds");
        JsonCompat.setPropertyNull(json, "operationTraits");
        JsonCompat.setPropertyNull(json, "messageTraits");
        JsonCompat.setPropertyNull(json, "serverBindings");
        JsonCompat.setPropertyNull(json, "channelBindings");
        JsonCompat.setPropertyNull(json, "operationBindings");
        JsonCompat.setPropertyNull(json, "messageBindings");
        JsonCompat.setProperty(parent, "components", json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    public void visitCorrelationId(AaiCorrelationId node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyString(json, "location", node.location);
        JsonCompat.setPropertyString(json, "description", node.description);
        JsonCompat.setPropertyString(json, "$ref", node.$ref);
        if (node.getName() != null) {
            Object map = JsonCompat.getProperty(parent, "correlationIds");
            if (map == null) {
                map = JsonCompat.objectNode();
                JsonCompat.setProperty(parent, "correlationIds", map);
            }
            JsonCompat.setProperty(map, node.getName(), json);
        } else {
            JsonCompat.setProperty(parent, "correlationId", json);
        }
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    public void visitHeaderItem(AaiHeaderItem node) {
        Object parent = this.lookupParentJson(node);
        Object json = JsonCompat.objectNode();
        if (node.$ref != null) {
            JsonCompat.setPropertyString(json, "$ref", node.$ref);
        } else {
            json = node._schemaRaw;
        }
        JsonCompat.setProperty(parent, "headers", json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    protected void doVisitOAuthFlow(OAuthFlow node, String flowName) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyString(json, "authorizationUrl", node.authorizationUrl);
        JsonCompat.setPropertyString(json, "tokenUrl", node.tokenUrl);
        JsonCompat.setPropertyString(json, "refreshUrl", node.refreshUrl);
        JsonCompat.setProperty(json, "scopes", node.scopes);
        JsonCompat.setProperty(parent, flowName, json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    public void visitImplicitOAuthFlow(ImplicitOAuthFlow node) {
        this.doVisitOAuthFlow(node, "implicit");
    }

    private Object writeMessageBase(AaiMessageBase node) {
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyNull(json, "headers");
        JsonCompat.setPropertyNull(json, "correlationId");
        JsonCompat.setPropertyString(json, "schemaFormat", node.schemaFormat);
        JsonCompat.setPropertyString(json, "contentType", node.contentType);
        JsonCompat.setPropertyString(json, "name", node.name);
        JsonCompat.setPropertyString(json, "title", node.title);
        JsonCompat.setPropertyString(json, "summary", node.summary);
        JsonCompat.setPropertyString(json, "description", node.description);
        JsonCompat.setPropertyString(json, "$ref", node.$ref);
        JsonCompat.setPropertyNull(json, "tags");
        JsonCompat.setPropertyNull(json, "externalDocs");
        JsonCompat.setPropertyNull(json, "bindings");
        return json;
    }

    @Override
    public void visitMessage(AaiMessage node) {
        Object parent = this.lookupParentJson(node);
        Object json = this.writeMessageBase(node);
        JsonCompat.setProperty(json, "payload", node.payload);
        JsonCompat.setPropertyNull(json, "traits");
        if (node.getName() != null) {
            Object map = JsonCompat.getProperty(parent, "messages");
            if (map == null) {
                map = JsonCompat.objectNode();
                JsonCompat.setProperty(parent, "messages", map);
            }
            JsonCompat.setProperty(map, node.getName(), json);
        } else if (node._isOneOfMessage) {
            Object list = JsonCompat.getProperty(parent, "oneOf");
            if (list == null) {
                list = JsonCompat.arrayNode();
                JsonCompat.setProperty(parent, "oneOf", list);
            }
            JsonCompat.appendToArray(list, json);
        } else {
            JsonCompat.setProperty(parent, "message", json);
        }
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    public void visitMessageTrait(AaiMessageTrait node) {
        Object json = this.writeMessageBase(node);
        Object parent = this.lookupParentJson(node);
        JsonCompat.appendToArrayProperty(parent, "traits", json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    public void visitOAuthFlows(OAuthFlows node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyNull(json, "implicit");
        JsonCompat.setPropertyNull(json, "password");
        JsonCompat.setPropertyNull(json, "clientCredentials");
        JsonCompat.setPropertyNull(json, "authorizationCode");
        JsonCompat.setProperty(parent, "flows", json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    protected void writeOperation(Object json, Operation node) {
        AaiOperation aaiNode = (AaiOperation)node;
        super.writeOperation(json, aaiNode);
    }

    protected Object writeOperationBase(AaiOperationBase node) {
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyString(json, "$ref", node.$ref);
        JsonCompat.setPropertyString(json, "operationId", node.operationId);
        JsonCompat.setPropertyString(json, "summary", node.summary);
        JsonCompat.setPropertyString(json, "description", node.description);
        JsonCompat.setPropertyNull(json, "externalDocs");
        JsonCompat.setPropertyNull(json, "tags");
        JsonCompat.setPropertyNull(json, "bindings");
        return json;
    }

    @Override
    public void visitOperation(Operation node) {
        AaiOperation aaiNode = (AaiOperation)node;
        Object parent = this.lookupParentJson(node);
        Object json = this.writeOperationBase(aaiNode);
        JsonCompat.setPropertyNull(json, "traits");
        JsonCompat.setPropertyNull(json, "message");
        JsonCompat.setProperty(parent, node.getType(), json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    public void visitOperationTrait(AaiOperationTrait node) {
        Object json = this.writeOperationBase(node);
        Object parent = this.lookupParentJson(node);
        JsonCompat.appendToArrayProperty(parent, "traits", json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    public void visitPasswordOAuthFlow(PasswordOAuthFlow node) {
        this.doVisitOAuthFlow(node, "password");
    }

    @Override
    public void visitAaiParameter(AaiParameter node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyString(json, "$ref", node.$ref);
        JsonCompat.setPropertyString(json, "description", node.description);
        JsonCompat.setProperty(json, "schema", node.schema);
        JsonCompat.setPropertyString(json, "location", node.location);
        if (node.getName() != null) {
            Object map = JsonCompat.getProperty(parent, "parameters");
            if (map == null) {
                map = JsonCompat.objectNode();
                JsonCompat.setProperty(parent, "parameters", map);
            }
            JsonCompat.setProperty(map, node.getName(), json);
        } else {
            Object list = JsonCompat.getProperty(parent, "parameters");
            if (list == null) {
                list = JsonCompat.arrayNode();
                JsonCompat.setProperty(parent, "parameters", list);
            }
            JsonCompat.appendToArray(list, json);
        }
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    protected void addSecuritySchemeToParent(Object parent, Object json, SecurityScheme node) {
        Object map;
        if (node.getName() != null) {
            map = JsonCompat.getProperty(parent, "securitySchemes");
            if (map == null) {
                map = JsonCompat.objectNode();
                JsonCompat.setProperty(parent, "securitySchemes", map);
            }
        } else {
            throw new IllegalStateException("error in writing a security scheme");
        }
        JsonCompat.setProperty(map, node.getName(), json);
    }

    @Override
    protected void writeSecurityScheme(Object json, SecurityScheme node) {
        AaiSecurityScheme aaiNode = (AaiSecurityScheme)node;
        super.writeSecurityScheme(json, node);
        JsonCompat.setPropertyString(json, "$ref", aaiNode.$ref);
        JsonCompat.setPropertyString(json, "scheme", aaiNode.scheme);
        JsonCompat.setPropertyString(json, "openIdConnectUrl", aaiNode.openIdConnectUrl);
        JsonCompat.setPropertyString(json, "bearerFormat", aaiNode.bearerFormat);
    }

    @Override
    public void visitMessageTraitDefinition(AaiMessageTraitDefinition node) {
        Object json = this.writeMessageBase(node);
        Object parent = this.lookupParentJson(node);
        Object map = JsonCompat.getProperty(parent, "messageTraits");
        if (map == null) {
            map = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "messageTraits", map);
        }
        JsonCompat.setProperty(map, node.getName(), json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    public void visitOperationTraitDefinition(AaiOperationTraitDefinition node) {
        Object json = this.writeOperationBase(node);
        Object parent = this.lookupParentJson(node);
        Object map = JsonCompat.getProperty(parent, "operationTraits");
        if (map == null) {
            map = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "operationTraits", map);
        }
        JsonCompat.setProperty(map, node.getName(), json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    public void visitServerBindings(AaiServerBindings node) {
        Object json = this.writeNullBindings();
        JsonCompat.setProperty(json, "http", node.http);
        JsonCompat.setProperty(json, "ws", node.ws);
        JsonCompat.setProperty(json, "kafka", node.kafka);
        JsonCompat.setProperty(json, "amqp", node.amqp);
        JsonCompat.setProperty(json, "amqp1", node.amqp1);
        JsonCompat.setProperty(json, "mqtt", node.mqtt);
        JsonCompat.setProperty(json, "mqtt5", node.mqtt5);
        JsonCompat.setProperty(json, "nats", node.nats);
        JsonCompat.setProperty(json, "jms", node.jms);
        JsonCompat.setProperty(json, "sns", node.sns);
        JsonCompat.setProperty(json, "sqs", node.sqs);
        JsonCompat.setProperty(json, "stomp", node.stomp);
        JsonCompat.setProperty(json, "redis", node.redis);
        Object parent = this.lookupParentJson(node);
        JsonCompat.setProperty(parent, "bindings", json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    public void visitServerBindingsDefinition(AaiServerBindingsDefinition node) {
        Object json = this.writeNullBindings();
        JsonCompat.setProperty(json, "http", node.http);
        JsonCompat.setProperty(json, "ws", node.ws);
        JsonCompat.setProperty(json, "kafka", node.kafka);
        JsonCompat.setProperty(json, "amqp", node.amqp);
        JsonCompat.setProperty(json, "amqp1", node.amqp1);
        JsonCompat.setProperty(json, "mqtt", node.mqtt);
        JsonCompat.setProperty(json, "mqtt5", node.mqtt5);
        JsonCompat.setProperty(json, "nats", node.nats);
        JsonCompat.setProperty(json, "jms", node.jms);
        JsonCompat.setProperty(json, "sns", node.sns);
        JsonCompat.setProperty(json, "sqs", node.sqs);
        JsonCompat.setProperty(json, "stomp", node.stomp);
        JsonCompat.setProperty(json, "redis", node.redis);
        Object parent = this.lookupParentJson(node);
        Object map = JsonCompat.getProperty(parent, "serverBindings");
        if (map == null) {
            map = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "serverBindings", map);
        }
        JsonCompat.setProperty(map, node.getName(), json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    public void visitOperationBindings(AaiOperationBindings node) {
        Object json = this.writeNullBindings();
        JsonCompat.setProperty(json, "http", node.http);
        JsonCompat.setProperty(json, "ws", node.ws);
        JsonCompat.setProperty(json, "kafka", node.kafka);
        JsonCompat.setProperty(json, "amqp", node.amqp);
        JsonCompat.setProperty(json, "amqp1", node.amqp1);
        JsonCompat.setProperty(json, "mqtt", node.mqtt);
        JsonCompat.setProperty(json, "mqtt5", node.mqtt5);
        JsonCompat.setProperty(json, "nats", node.nats);
        JsonCompat.setProperty(json, "jms", node.jms);
        JsonCompat.setProperty(json, "sns", node.sns);
        JsonCompat.setProperty(json, "sqs", node.sqs);
        JsonCompat.setProperty(json, "stomp", node.stomp);
        JsonCompat.setProperty(json, "redis", node.redis);
        Object parent = this.lookupParentJson(node);
        JsonCompat.setProperty(parent, "bindings", json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    public void visitOperationBindingsDefinition(AaiOperationBindingsDefinition node) {
        Object json = this.writeNullBindings();
        JsonCompat.setProperty(json, "http", node.http);
        JsonCompat.setProperty(json, "ws", node.ws);
        JsonCompat.setProperty(json, "kafka", node.kafka);
        JsonCompat.setProperty(json, "amqp", node.amqp);
        JsonCompat.setProperty(json, "amqp1", node.amqp1);
        JsonCompat.setProperty(json, "mqtt", node.mqtt);
        JsonCompat.setProperty(json, "mqtt5", node.mqtt5);
        JsonCompat.setProperty(json, "nats", node.nats);
        JsonCompat.setProperty(json, "jms", node.jms);
        JsonCompat.setProperty(json, "sns", node.sns);
        JsonCompat.setProperty(json, "sqs", node.sqs);
        JsonCompat.setProperty(json, "stomp", node.stomp);
        JsonCompat.setProperty(json, "redis", node.redis);
        Object parent = this.lookupParentJson(node);
        Object map = JsonCompat.getProperty(parent, "operationBindings");
        if (map == null) {
            map = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "operationBindings", map);
        }
        JsonCompat.setProperty(map, node.getName(), json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    public void visitMessageBindings(AaiMessageBindings node) {
        Object json = this.writeNullBindings();
        JsonCompat.setProperty(json, "http", node.http);
        JsonCompat.setProperty(json, "ws", node.ws);
        JsonCompat.setProperty(json, "kafka", node.kafka);
        JsonCompat.setProperty(json, "amqp", node.amqp);
        JsonCompat.setProperty(json, "amqp1", node.amqp1);
        JsonCompat.setProperty(json, "mqtt", node.mqtt);
        JsonCompat.setProperty(json, "mqtt5", node.mqtt5);
        JsonCompat.setProperty(json, "nats", node.nats);
        JsonCompat.setProperty(json, "jms", node.jms);
        JsonCompat.setProperty(json, "sns", node.sns);
        JsonCompat.setProperty(json, "sqs", node.sqs);
        JsonCompat.setProperty(json, "stomp", node.stomp);
        JsonCompat.setProperty(json, "redis", node.redis);
        Object parent = this.lookupParentJson(node);
        JsonCompat.setProperty(parent, "bindings", json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    public void visitMessageBindingsDefinition(AaiMessageBindingsDefinition node) {
        Object json = this.writeNullBindings();
        JsonCompat.setProperty(json, "http", node.http);
        JsonCompat.setProperty(json, "ws", node.ws);
        JsonCompat.setProperty(json, "kafka", node.kafka);
        JsonCompat.setProperty(json, "amqp", node.amqp);
        JsonCompat.setProperty(json, "amqp1", node.amqp1);
        JsonCompat.setProperty(json, "mqtt", node.mqtt);
        JsonCompat.setProperty(json, "mqtt5", node.mqtt5);
        JsonCompat.setProperty(json, "nats", node.nats);
        JsonCompat.setProperty(json, "jms", node.jms);
        JsonCompat.setProperty(json, "sns", node.sns);
        JsonCompat.setProperty(json, "sqs", node.sqs);
        JsonCompat.setProperty(json, "stomp", node.stomp);
        JsonCompat.setProperty(json, "redis", node.redis);
        Object parent = this.lookupParentJson(node);
        Object map = JsonCompat.getProperty(parent, "messageBindings");
        if (map == null) {
            map = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "messageBindings", map);
        }
        JsonCompat.setProperty(map, node.getName(), json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    public void visitChannelBindings(AaiChannelBindings node) {
        Object json = this.writeNullBindings();
        JsonCompat.setProperty(json, "http", node.http);
        JsonCompat.setProperty(json, "ws", node.ws);
        JsonCompat.setProperty(json, "kafka", node.kafka);
        JsonCompat.setProperty(json, "amqp", node.amqp);
        JsonCompat.setProperty(json, "amqp1", node.amqp1);
        JsonCompat.setProperty(json, "mqtt", node.mqtt);
        JsonCompat.setProperty(json, "mqtt5", node.mqtt5);
        JsonCompat.setProperty(json, "nats", node.nats);
        JsonCompat.setProperty(json, "jms", node.jms);
        JsonCompat.setProperty(json, "sns", node.sns);
        JsonCompat.setProperty(json, "sqs", node.sqs);
        JsonCompat.setProperty(json, "stomp", node.stomp);
        JsonCompat.setProperty(json, "redis", node.redis);
        Object parent = this.lookupParentJson(node);
        JsonCompat.setProperty(parent, "bindings", json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    @Override
    public void visitChannelBindingsDefinition(AaiChannelBindingsDefinition node) {
        Object json = this.writeNullBindings();
        JsonCompat.setProperty(json, "http", node.http);
        JsonCompat.setProperty(json, "ws", node.ws);
        JsonCompat.setProperty(json, "kafka", node.kafka);
        JsonCompat.setProperty(json, "amqp", node.amqp);
        JsonCompat.setProperty(json, "amqp1", node.amqp1);
        JsonCompat.setProperty(json, "mqtt", node.mqtt);
        JsonCompat.setProperty(json, "mqtt5", node.mqtt5);
        JsonCompat.setProperty(json, "nats", node.nats);
        JsonCompat.setProperty(json, "jms", node.jms);
        JsonCompat.setProperty(json, "sns", node.sns);
        JsonCompat.setProperty(json, "sqs", node.sqs);
        JsonCompat.setProperty(json, "stomp", node.stomp);
        JsonCompat.setProperty(json, "redis", node.redis);
        Object parent = this.lookupParentJson(node);
        Object map = JsonCompat.getProperty(parent, "channelBindings");
        if (map == null) {
            map = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "channelBindings", map);
        }
        JsonCompat.setProperty(map, node.getName(), json);
        this.writeExtraProperties(json, node);
        this.updateIndex(node, json);
    }

    protected Object writeNullBindings() {
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyNull(json, "http");
        JsonCompat.setPropertyNull(json, "ws");
        JsonCompat.setPropertyNull(json, "kafka");
        JsonCompat.setPropertyNull(json, "amqp");
        JsonCompat.setPropertyNull(json, "amqp1");
        JsonCompat.setPropertyNull(json, "mqtt");
        JsonCompat.setPropertyNull(json, "mqtt5");
        JsonCompat.setPropertyNull(json, "nats");
        JsonCompat.setPropertyNull(json, "jms");
        JsonCompat.setPropertyNull(json, "sns");
        JsonCompat.setPropertyNull(json, "sqs");
        JsonCompat.setPropertyNull(json, "stomp");
        JsonCompat.setPropertyNull(json, "redis");
        return json;
    }
}

