/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.v3.models.Oas30Example;
import io.apicurio.datamodels.openapi.v3.models.Oas30MediaType;

public class AddExampleCommand_30
extends AbstractCommand {
    public NodePath _parentPath;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _newExampleValue;
    public String _newExampleName;
    public String _newExampleSummary;
    public String _newExampleDescription;
    public boolean _exampleAdded;

    AddExampleCommand_30() {
    }

    AddExampleCommand_30(Oas30MediaType parent, Object example, String exampleName) {
        this._parentPath = Library.createNodePath(parent);
        this._newExampleValue = example;
        this._newExampleName = exampleName;
    }

    AddExampleCommand_30(Oas30MediaType parent, Object example, String exampleName, String exampleSummary, String exampleDescription) {
        this._parentPath = Library.createNodePath(parent);
        this._newExampleValue = example;
        this._newExampleName = exampleName;
        this._newExampleSummary = exampleSummary;
        this._newExampleDescription = exampleDescription;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[AddExampleCommand_30] Executing.", new Object[0]);
        this._exampleAdded = false;
        Oas30MediaType mediaType = (Oas30MediaType)this._parentPath.resolve(document);
        if (this.isNullOrUndefined(mediaType)) {
            return;
        }
        if (!this.isNullOrUndefined(mediaType.getExample(this._newExampleName))) {
            return;
        }
        Oas30Example example = mediaType.createExample(this._newExampleName);
        example.summary = this._newExampleSummary;
        example.description = this._newExampleDescription;
        example.value = this._newExampleValue;
        mediaType.addExample(example);
        this._exampleAdded = true;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[AddExampleCommand_30] Reverting.", new Object[0]);
        if (!this._exampleAdded) {
            return;
        }
        Oas30MediaType mediaType = (Oas30MediaType)this._parentPath.resolve(document);
        if (this.isNullOrUndefined(mediaType) || this.isNullOrUndefined(mediaType.examples)) {
            return;
        }
        mediaType.removeExample(this._newExampleName);
    }
}

