/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.commands.NewSecuritySchemeCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30SecurityScheme;

public class NewSecuritySchemeCommand_30
extends NewSecuritySchemeCommand {
    public boolean _nullComponents;

    NewSecuritySchemeCommand_30() {
    }

    NewSecuritySchemeCommand_30(SecurityScheme scheme) {
        super(scheme);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[NewSecuritySchemeCommand] Executing.", new Object[0]);
        Oas30Document doc30 = (Oas30Document)document;
        this._nullComponents = false;
        if (this.isNullOrUndefined(doc30.components)) {
            doc30.components = doc30.createComponents();
            this._nullComponents = true;
        }
        if (this.isNullOrUndefined(doc30.components.getSecurityScheme(this._schemeName))) {
            Oas30SecurityScheme scheme = doc30.components.createSecurityScheme(this._schemeName);
            Library.readNode(this._scheme, scheme);
            doc30.components.addSecurityScheme(this._schemeName, scheme);
            this._schemeExisted = false;
        } else {
            this._schemeExisted = true;
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewSecuritySchemeCommand] Reverting.", new Object[0]);
        if (this._schemeExisted) {
            return;
        }
        Oas30Document doc30 = (Oas30Document)document;
        if (this._nullComponents) {
            doc30.components = null;
            return;
        }
        doc30.components.removeSecurityScheme(this._schemeName);
    }
}

