/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.IOasPropertySchema;
import io.apicurio.datamodels.openapi.models.OasSchema;
import java.util.List;

public class RenamePropertyCommand
extends AbstractCommand {
    public NodePath _parentPath;
    public String _oldPropertyName;
    public String _newPropertyName;

    RenamePropertyCommand() {
    }

    RenamePropertyCommand(OasSchema parent, String oldPropertyName, String newPropertyName) {
        this._oldPropertyName = oldPropertyName;
        this._newPropertyName = newPropertyName;
        this._parentPath = Library.createNodePath(parent);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[RenamePropertyCommand] Executing.", new Object[0]);
        this._doPropertyRename(document, this._oldPropertyName, this._newPropertyName);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[RenamePropertyCommand] Reverting.", new Object[0]);
        this._doPropertyRename(document, this._newPropertyName, this._oldPropertyName);
    }

    private void _doPropertyRename(Document document, String from, String to) {
        int reqIdx;
        OasSchema parent = (OasSchema)this._parentPath.resolve(document);
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        if (!this.isNullOrUndefined(parent.getProperty(to))) {
            return;
        }
        OasSchema property = parent.removeProperty(from);
        if (this.isNullOrUndefined(property)) {
            return;
        }
        ((IOasPropertySchema)((Object)property)).rename(to);
        parent.addProperty(to, property);
        List<String> required = parent.required;
        int n = reqIdx = ModelUtils.isDefined(required) ? required.indexOf(from) : -1;
        if (reqIdx != -1) {
            parent.required.set(reqIdx, to);
        }
    }
}

