/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.util;

import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.compat.RegexCompat;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.util.ReferenceResolverChain;
import io.apicurio.datamodels.core.util.ResolverOptions;
import io.apicurio.datamodels.core.util.ResolverOptionsType;
import java.util.HashSet;
import java.util.List;

public class ReferenceUtil {
    public static Node resolveNodeRef(Node node) {
        return ReferenceUtil.resolveNodeRef(node, ResolverOptions.of(ResolverOptionsType.RECURSIVE));
    }

    public static Node resolveNodeRef(Node node, ResolverOptions options) {
        if (!ReferenceUtil.hasValue(node)) {
            return null;
        }
        String $ref = (String)NodeCompat.getProperty(node, "$ref");
        return ReferenceUtil.resolveRef($ref, node, options);
    }

    public static Node resolveRef(String $ref, Node from) {
        if (!ReferenceUtil.hasValue($ref)) {
            return null;
        }
        return ReferenceUtil.resolveRef($ref, from, ResolverOptions.of(ResolverOptionsType.RECURSIVE, ResolverOptionsType.NULL_IF_NOT_FOUND));
    }

    public static Node resolveRef(String $ref, Node from, ResolverOptions options) {
        ReferenceResolverChain resolver = ReferenceResolverChain.getInstance();
        Node rval = null;
        if (ReferenceUtil.hasValue($ref)) {
            rval = resolver.resolveRef($ref, from);
        }
        if (rval != null && options.contains(ResolverOptionsType.RECURSIVE)) {
            HashSet<String> observedRefs = new HashSet<String>();
            boolean done = false;
            while (!done) {
                observedRefs.add($ref);
                $ref = (String)NodeCompat.getProperty(rval, "$ref");
                if (ReferenceUtil.hasValue($ref) && !observedRefs.contains($ref)) {
                    rval = resolver.resolveRef($ref, from);
                } else if (observedRefs.contains($ref)) {
                    rval = null;
                    done = true;
                } else {
                    done = true;
                }
                if (ReferenceUtil.hasValue(rval)) continue;
                done = true;
            }
        }
        if (rval != null) {
            return rval;
        }
        if (options.contains(ResolverOptionsType.NULL_IF_NOT_FOUND)) {
            return null;
        }
        return from;
    }

    public static boolean canResolveRef(String $ref, Node from) {
        return ReferenceUtil.hasValue(ReferenceUtil.resolveRef($ref, from));
    }

    public static boolean hasValue(Object value) {
        return !NodeCompat.isNullOrUndefined(value);
    }

    public static Object resolveFragmentFromJS(Object contextNode, String fragment) {
        List<String[]> split = RegexCompat.findMatches(fragment, "([^/]+)/?");
        Object cnode = contextNode;
        for (String[] mi : split) {
            String seg = mi[1];
            if (NodeCompat.equals(seg, "#")) {
                cnode = contextNode;
                continue;
            }
            if (cnode == null) continue;
            cnode = JsonCompat.getProperty(cnode, seg);
        }
        return cnode;
    }
}

