/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.io;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.io.DataModelWriter;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.models.common.IExample;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.openapi.models.IOasPropertySchema;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasPaths;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.models.OasResponses;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.models.OasXML;
import io.apicurio.datamodels.openapi.visitors.IOasVisitor;

public class OasDataModelWriter
extends DataModelWriter
implements IOasVisitor {
    @Override
    public void visitPaths(OasPaths node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        this.writeExtraProperties(json, node);
        JsonCompat.setProperty(parent, "paths", json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitPathItem(OasPathItem node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        this.writePathItem(json, node);
        this.writeExtraProperties(json, node);
        JsonCompat.setProperty(parent, node.getPath(), json);
        this.updateIndex(node, json);
    }

    protected void writePathItem(Object json, OasPathItem node) {
        JsonCompat.setPropertyString(json, "$ref", node.$ref);
        JsonCompat.setPropertyNull(json, "get");
        JsonCompat.setPropertyNull(json, "put");
        JsonCompat.setPropertyNull(json, "post");
        JsonCompat.setPropertyNull(json, "delete");
        JsonCompat.setPropertyNull(json, "options");
        JsonCompat.setPropertyNull(json, "head");
        JsonCompat.setPropertyNull(json, "patch");
        JsonCompat.setPropertyNull(json, "parameters");
    }

    @Override
    public void visitResponse(OasResponse node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        this.writeResponse(json, node);
        this.writeExtraProperties(json, node);
        String responseCode = node.getName();
        if (responseCode == null) {
            responseCode = "default";
        }
        JsonCompat.setProperty(parent, responseCode, json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitResponses(OasResponses node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyNull(json, "default");
        this.writeExtraProperties(json, node);
        JsonCompat.setProperty(parent, "responses", json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitXML(OasXML node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyString(json, "name", node.name);
        JsonCompat.setPropertyString(json, "namespace", node.namespace);
        JsonCompat.setPropertyString(json, "prefix", node.prefix);
        JsonCompat.setPropertyBoolean(json, "attribute", node.attribute);
        JsonCompat.setPropertyBoolean(json, "wrapped", node.wrapped);
        this.writeExtraProperties(json, node);
        JsonCompat.setProperty(parent, "xml", json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitAllOfSchema(OasSchema node) {
        this.doVisitSchema(node, "allOf", true);
    }

    @Override
    public void visitItemsSchema(OasSchema node) {
        OasSchema parentSchema = node;
        this.doVisitSchema(node, "items", NodeCompat.isList(parentSchema.items));
    }

    @Override
    public void visitAdditionalPropertiesSchema(OasSchema node) {
        this.doVisitSchema(node, "additionalProperties", false);
    }

    @Override
    public void visitPropertySchema(IOasPropertySchema node) {
        OasSchema schema = (OasSchema)((Object)node);
        Object parent = this.lookupParentJson(schema);
        ObjectNode json = JsonCompat.objectNode();
        this.writeSchema(json, schema);
        this.writeExtraProperties(json, schema);
        Object properties = JsonCompat.getProperty(parent, "properties");
        if (properties == null) {
            properties = JsonCompat.objectNode();
            JsonCompat.setProperty(parent, "properties", properties);
        }
        JsonCompat.setProperty(properties, node.getPropertyName(), json);
        this.updateIndex(schema, json);
    }

    @Override
    protected void writeSchema(Object json, Schema node) {
        OasSchema schema = (OasSchema)node;
        JsonCompat.setPropertyString(json, "$ref", schema.$ref);
        JsonCompat.setPropertyString(json, "format", schema.format);
        JsonCompat.setPropertyString(json, "title", schema.title);
        JsonCompat.setPropertyString(json, "description", schema.description);
        JsonCompat.setProperty(json, "default", schema.default_);
        JsonCompat.setPropertyNumber(json, "multipleOf", schema.multipleOf);
        JsonCompat.setPropertyNumber(json, "maximum", schema.maximum);
        JsonCompat.setPropertyBoolean(json, "exclusiveMaximum", schema.exclusiveMaximum);
        JsonCompat.setPropertyNumber(json, "minimum", schema.minimum);
        JsonCompat.setPropertyBoolean(json, "exclusiveMinimum", schema.exclusiveMinimum);
        JsonCompat.setPropertyNumber(json, "maxLength", schema.maxLength);
        JsonCompat.setPropertyNumber(json, "minLength", schema.minLength);
        JsonCompat.setPropertyString(json, "pattern", schema.pattern);
        JsonCompat.setPropertyNumber(json, "maxItems", schema.maxItems);
        JsonCompat.setPropertyNumber(json, "minItems", schema.minItems);
        JsonCompat.setPropertyBoolean(json, "uniqueItems", schema.uniqueItems);
        JsonCompat.setPropertyNumber(json, "maxProperties", schema.maxProperties);
        JsonCompat.setPropertyNumber(json, "minProperties", schema.minProperties);
        JsonCompat.setPropertyStringArray(json, "required", schema.required);
        JsonCompat.setPropertyStringArray(json, "enum", schema.enum_);
        JsonCompat.setPropertyString(json, "type", schema.type);
        JsonCompat.setPropertyNull(json, "items");
        JsonCompat.setPropertyNull(json, "allOf");
        JsonCompat.setPropertyNull(json, "properties");
        if (NodeCompat.isNode(schema.additionalProperties)) {
            JsonCompat.setPropertyNull(json, "additionalProperties");
        } else {
            JsonCompat.setPropertyBoolean(json, "additionalProperties", (Boolean)schema.additionalProperties);
        }
        JsonCompat.setPropertyBoolean(json, "readOnly", schema.readOnly);
        JsonCompat.setPropertyNull(json, "xml");
        JsonCompat.setPropertyNull(json, "externalDocs");
        JsonCompat.setProperty(json, "example", schema.example);
        super.writeSchema(json, schema);
    }

    @Override
    protected void writeOperation(Object json, Operation node) {
        OasOperation operation = (OasOperation)node;
        JsonCompat.setPropertyStringArray(json, "tags", operation.tags);
        JsonCompat.setPropertyNull(json, "parameters");
        JsonCompat.setPropertyNull(json, "responses");
        JsonCompat.setPropertyBoolean(json, "deprecated", operation.deprecated);
        JsonCompat.setPropertyNull(json, "security");
        super.writeOperation(json, node);
    }

    @Override
    protected void writeParameter(Object json, Parameter node) {
        super.writeParameter(json, node);
        OasParameter param = (OasParameter)node;
        JsonCompat.setPropertyString(json, "in", param.in);
        JsonCompat.setPropertyBoolean(json, "required", param.required);
        JsonCompat.setPropertyBoolean(json, "allowEmptyValue", param.allowEmptyValue);
    }

    @Override
    public void visitHeader(OasHeader node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        this.writeHeader(json, node);
        this.writeExtraProperties(json, node);
        this.addHeaderToParent(parent, json, node);
        this.updateIndex(node, json);
    }

    protected void writeHeader(Object json, OasHeader node) {
        JsonCompat.setProperty(json, "description", node.description);
    }

    protected void addHeaderToParent(Object parent, Object json, OasHeader node) {
        JsonCompat.setProperty(parent, node.getName(), json);
    }

    @Override
    public void visitResponseDefinition(IDefinition node) {
        OasResponse response = (OasResponse)((Object)node);
        Object parent = this.lookupParentJson(response);
        ObjectNode json = JsonCompat.objectNode();
        this.writeResponse(json, response);
        this.writeExtraProperties(json, response);
        this.addResponseDefinitionToParent(parent, json, node);
        this.updateIndex(response, json);
    }

    protected void writeResponse(Object json, OasResponse node) {
        JsonCompat.setPropertyString(json, "$ref", node.$ref);
        JsonCompat.setPropertyString(json, "description", node.description);
    }

    protected void addResponseDefinitionToParent(Object parent, Object json, IDefinition node) {
        JsonCompat.setProperty(parent, node.getName(), json);
    }

    @Override
    public void visitExample(IExample node) {
        throw new RuntimeException("Must be implemented by subclasses.");
    }
}

