/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.models;

import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.ExtensibleNode;
import io.apicurio.datamodels.core.models.IReferenceNode;
import io.apicurio.datamodels.core.visitors.IVisitor;
import io.apicurio.datamodels.openapi.models.IOasParameterParent;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.visitors.IOasVisitor;
import java.util.ArrayList;
import java.util.List;

public abstract class OasPathItem
extends ExtensibleNode
implements IOasParameterParent,
IReferenceNode {
    private String _path;
    public String $ref;
    public OasOperation get;
    public OasOperation put;
    public OasOperation post;
    public OasOperation delete;
    public OasOperation options;
    public OasOperation head;
    public OasOperation patch;
    public List<OasParameter> parameters;

    public OasPathItem(String path) {
        this._path = path;
    }

    public void rename(String newPath) {
        this._path = newPath;
    }

    @Override
    public String getReference() {
        return this.$ref;
    }

    @Override
    public void setReference(String reference) {
        this.$ref = reference;
    }

    @Override
    public List<OasParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public List<OasParameter> getParametersIn(String in) {
        ArrayList<OasParameter> params = new ArrayList<OasParameter>();
        if (ModelUtils.isDefined(this.parameters)) {
            this.parameters.forEach(param -> {
                if (NodeCompat.equals(param.in, in)) {
                    params.add((OasParameter)param);
                }
            });
        }
        return params;
    }

    public String getPath() {
        return this._path;
    }

    @Override
    public void accept(IVisitor visitor) {
        IOasVisitor oasVisitor = (IOasVisitor)visitor;
        oasVisitor.visitPathItem(this);
    }

    public abstract OasOperation createOperation(String var1);

    @Override
    public abstract OasParameter createParameter();

    @Override
    public OasParameter addParameter(OasParameter param) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<OasParameter>();
        }
        this.parameters.add(param);
        return param;
    }

    @Override
    public OasParameter getParameter(String in, String name) {
        if (this.parameters == null) {
            return null;
        }
        for (OasParameter param : this.parameters) {
            if (!NodeCompat.equals(in, param.in) || !NodeCompat.equals(name, param.name)) continue;
            return param;
        }
        return null;
    }

    public void setOperation(OasOperation operation) {
        if (NodeCompat.equals("get", operation.getMethod())) {
            this.get = operation;
        } else if (NodeCompat.equals("put", operation.getMethod())) {
            this.put = operation;
        } else if (NodeCompat.equals("post", operation.getMethod())) {
            this.post = operation;
        } else if (NodeCompat.equals("delete", operation.getMethod())) {
            this.delete = operation;
        } else if (NodeCompat.equals("head", operation.getMethod())) {
            this.head = operation;
        } else if (NodeCompat.equals("patch", operation.getMethod())) {
            this.patch = operation;
        } else if (NodeCompat.equals("options", operation.getMethod())) {
            this.options = operation;
        }
    }
}

