/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiHeaderItem;
import io.apicurio.datamodels.asyncapi.models.AaiOperation;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20NodeFactory;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;

public class ChangeHeadersRefCommand_Aai20
extends AbstractCommand {
    public NodePath _operationPath;
    public String _headersRef;
    public String _oldHeadersRef = null;
    public boolean _changed;

    ChangeHeadersRefCommand_Aai20() {
    }

    ChangeHeadersRefCommand_Aai20(String headersRef, AaiOperation operationNode) {
        this._operationPath = Library.createNodePath(operationNode);
        this._headersRef = headersRef;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[ChangeHeadersRefCommand_Aai20] Executing.", new Object[0]);
        AaiOperation operation = (AaiOperation)this._operationPath.resolve(document);
        this._changed = false;
        if (this.isNullOrUndefined(operation) || this.isNullOrUndefined(operation.message) || !this.isValidRef(this._headersRef)) {
            return;
        }
        AaiHeaderItem headerItem = operation.message.headers;
        if (headerItem == null) {
            Aai20NodeFactory nodeFactory = new Aai20NodeFactory();
            operation.message.headers = headerItem = nodeFactory.createHeaderItem(operation.message);
        }
        if (headerItem.$ref != null) {
            this._oldHeadersRef = headerItem.$ref;
        }
        headerItem.$ref = this._headersRef;
        this._changed = true;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ChangeHeadersRefCommand_Aai20] Reverting.", new Object[0]);
        AaiOperation operation = (AaiOperation)this._operationPath.resolve(document);
        if (!this._changed || this.isNullOrUndefined(operation) || this.isNullOrUndefined(operation.message)) {
            return;
        }
        AaiHeaderItem headerItem = operation.message.headers;
        headerItem.$ref = this._oldHeadersRef != null ? this._oldHeadersRef : null;
    }

    private boolean isValidRef(String refCandidate) {
        return ModelUtils.isDefined(refCandidate) && refCandidate.startsWith("#/");
    }
}

