/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.IOasHeaderParent;
import io.apicurio.datamodels.openapi.models.OasHeader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeleteAllHeadersCommand
extends AbstractCommand {
    public NodePath _parentPath;
    @JsonDeserialize(contentUsing=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Map<String, Object> _oldHeaders;

    DeleteAllHeadersCommand() {
    }

    DeleteAllHeadersCommand(IOasHeaderParent parent) {
        this._parentPath = Library.createNodePath((Node)((Object)parent));
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteAllHeadersCommand] Executing.", new Object[0]);
        IOasHeaderParent parent = (IOasHeaderParent)((Object)this._parentPath.resolve(document));
        List<OasHeader> headers = parent.getHeaders();
        if (this.isNullOrUndefined(parent) || this.isNullOrUndefined(headers) || headers.size() == 0) {
            return;
        }
        this._oldHeaders = new HashMap<String, Object>();
        ArrayList<OasHeader> headersToRemove = new ArrayList<OasHeader>();
        for (OasHeader header : headers) {
            this._oldHeaders.put(header.getName(), Library.writeNode(header));
            headersToRemove.add(header);
        }
        if (this._oldHeaders.size() == 0) {
            return;
        }
        headersToRemove.forEach(headerToRemove -> parent.removeHeader(headerToRemove.getName()));
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteAllHeaders] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldHeaders) || this._oldHeaders.size() == 0) {
            return;
        }
        IOasHeaderParent parent = (IOasHeaderParent)((Object)this._parentPath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        for (String k : this._oldHeaders.keySet()) {
            OasHeader header = parent.createHeader(k);
            Library.readNode(this._oldHeaders.get(k), header);
            parent.addHeader(k, header);
        }
    }
}

