/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.commands.AbstractSchemaInhCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import java.util.ArrayList;
import java.util.List;

public class ChangeSchemaInheritanceCommand
extends AbstractSchemaInhCommand {
    public NodePath _schemaPath;
    public String _newInheritanceType;
    public String _oldInheritanceType;
    @JsonDeserialize(contentUsing=MarshallCompat.NullableJsonNodeDeserializer.class)
    public List<Object> _oldSchemas;

    ChangeSchemaInheritanceCommand() {
    }

    ChangeSchemaInheritanceCommand(OasSchema schema, String inheritanceType) {
        this._schemaPath = Library.createNodePath(schema);
        this._newInheritanceType = inheritanceType;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[ChangeSchemaInheritanceCommand] Executing: " + this._newInheritanceType, new Object[0]);
        this._oldInheritanceType = null;
        this._oldSchemas = null;
        OasSchema schema = (OasSchema)this._schemaPath.resolve(document);
        if (this.isNullOrUndefined(schema)) {
            return;
        }
        this._oldInheritanceType = ChangeSchemaInheritanceCommand.getInheritanceType(schema);
        this.switchInheritance(schema, this._oldInheritanceType, this._newInheritanceType, false);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ChangeSchemaInheritanceCommand] Reverting: " + this._oldInheritanceType, new Object[0]);
        OasSchema schema = (OasSchema)this._schemaPath.resolve(document);
        if (this.isNullOrUndefined(schema)) {
            return;
        }
        this.switchInheritance(schema, this._newInheritanceType, this._oldInheritanceType, true);
        if (NodeCompat.equals("none", this._newInheritanceType) && !this._oldSchemas.isEmpty()) {
            this.copySchemaJsTo(this._oldSchemas, schema, this._oldInheritanceType);
        }
    }

    private void switchInheritance(OasSchema schema, String fromType, String toType, boolean isUndo) {
        Oas30Schema schema30;
        if (NodeCompat.equals(fromType, toType)) {
            return;
        }
        List<Object> schemas = new ArrayList();
        if (NodeCompat.equals("allOf", fromType)) {
            schemas = schema.allOf;
            schema.allOf = null;
        }
        if (NodeCompat.equals("anyOf", fromType)) {
            schema30 = (Oas30Schema)schema;
            schemas = schema30.anyOf;
            schema30.anyOf = null;
        }
        if (NodeCompat.equals("oneOf", fromType)) {
            schema30 = (Oas30Schema)schema;
            schemas = schema30.oneOf;
            schema30.oneOf = null;
        }
        if (NodeCompat.equals("none", toType)) {
            if (!isUndo) {
                this._oldSchemas = new ArrayList<Object>();
            }
            schemas.forEach(s -> {
                if (ModelUtils.isDefined(s.properties)) {
                    this.moveProperties((OasSchema)s, schema);
                } else if (!isUndo) {
                    this._oldSchemas.add(Library.writeNode(s));
                }
            });
        }
        if (NodeCompat.equals("none", fromType)) {
            OasSchema wrapperSchema = this.createSchema(schema, fromType);
            wrapperSchema.type = "object";
            this.moveProperties(schema, wrapperSchema);
            schemas.add(wrapperSchema);
        }
        if (!schemas.isEmpty()) {
            this.copySchemasTo(schemas, schema, toType);
        }
    }

    private void copySchemasTo(List<OasSchema> schemas, OasSchema targetSchema, String inheritanceType) {
        ArrayList<Object> jsSchemas = new ArrayList<Object>();
        schemas.forEach(schema -> jsSchemas.add(Library.writeNode(schema)));
        this.copySchemaJsTo(jsSchemas, targetSchema, inheritanceType);
    }

    private void moveProperties(OasSchema from, OasSchema to) {
        to.properties = from.properties;
        from.properties = null;
        if (!this.isNullOrUndefined(to.properties)) {
            to.properties.values().forEach(pschema -> {
                pschema._parent = to;
            });
        }
        to.required = from.required;
        from.required = null;
    }
}

