/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.common.IExample;
import io.apicurio.datamodels.core.models.common.IExamplesParent;
import java.util.LinkedHashMap;
import java.util.Map;

public class DeleteAllExamplesCommand
extends AbstractCommand {
    public NodePath _mediaTypePath;
    @JsonDeserialize(contentUsing=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Map<String, Object> _oldExamples;

    DeleteAllExamplesCommand() {
    }

    DeleteAllExamplesCommand(IExamplesParent parent) {
        this._mediaTypePath = Library.createNodePath((Node)((Object)parent));
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteAllExamplesCommand] Executing.", new Object[0]);
        if (this.isNullOrUndefined(document)) {
            LoggerCompat.debug("[DeleteAllExamplesCommand] Could not execute the command, invalid argument.", new Object[0]);
            return;
        }
        if (this.isNullOrUndefined(this._mediaTypePath)) {
            LoggerCompat.debug("[DeleteAllExamplesCommand] Could not execute the command, problem when unmarshalling.", new Object[0]);
            return;
        }
        IExamplesParent parent = (IExamplesParent)((Object)this._mediaTypePath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            LoggerCompat.debug("[DeleteAllExamplesCommand] Media type not found.", new Object[0]);
            return;
        }
        this._oldExamples = new LinkedHashMap<String, Object>();
        parent.getExamples().forEach(e -> this._oldExamples.put(e.getName(), Library.writeNode((Node)((Object)e))));
        parent.clearExamples();
    }

    @Override
    public void undo(Document document) {
        if (this.isNullOrUndefined(document)) {
            LoggerCompat.debug("[DeleteAllExamplesCommand] Could not revert the command, invalid argument.", new Object[0]);
            return;
        }
        if (this.isNullOrUndefined(this._mediaTypePath)) {
            LoggerCompat.debug("[DeleteAllExamplesCommand] Could not revert the command, problem when unmarshalling.", new Object[0]);
            return;
        }
        LoggerCompat.info("[DeleteAllExamplesCommand] Reverting.", new Object[0]);
        IExamplesParent parent = (IExamplesParent)((Object)this._mediaTypePath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            LoggerCompat.info("[DeleteAllExamplesCommand] No media type found.", new Object[0]);
            return;
        }
        if (this.isNullOrUndefined(this._oldExamples)) {
            LoggerCompat.info("[DeleteAllExamplesCommand] Could not revert. Previous data is not available.", new Object[0]);
            return;
        }
        for (String k : this._oldExamples.keySet()) {
            IExample example = parent.createExample(k);
            Library.readNode(this._oldExamples.get(k), (Node)((Object)example));
            parent.addExample(example);
        }
    }
}

