/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.commands.AbstractSchemaInhCommand;
import io.apicurio.datamodels.combined.visitors.CombinedVisitorAdapter;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;

public class DeleteChildSchemaCommand
extends AbstractSchemaInhCommand {
    public NodePath _schemaPath;
    public NodePath _parentPath;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldSchema;
    public String _oldSchemaType;
    public Integer _oldSchemaIndex;

    DeleteChildSchemaCommand() {
    }

    DeleteChildSchemaCommand(OasSchema schema) {
        this._schemaPath = Library.createNodePath(schema);
        this._parentPath = Library.createNodePath(schema.parent());
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteChildSchemaCommand] Executing.", new Object[0]);
        this._oldSchema = null;
        OasSchema childSchema = (OasSchema)this._schemaPath.resolve(document);
        if (this.isNullOrUndefined(childSchema)) {
            return;
        }
        SchemaRemoverVisitor schemaRemover = new SchemaRemoverVisitor();
        Library.visitNode(childSchema, schemaRemover);
        this._oldSchema = Library.writeNode(childSchema);
        this._oldSchemaType = schemaRemover.type;
        this._oldSchemaIndex = schemaRemover.index;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteChildSchemaCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldSchema)) {
            return;
        }
        OasSchema parent = (OasSchema)this._parentPath.resolve(document);
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        OasSchema schema = this.createSchema(parent, this._oldSchemaType);
        Library.readNode(this._oldSchema, schema);
        SchemaAdderVisitor schemaAdder = new SchemaAdderVisitor(this._oldSchemaIndex);
        Library.visitNode(schema, schemaAdder);
    }

    private static class SchemaAdderVisitor
    extends CombinedVisitorAdapter {
        private Integer index;

        SchemaAdderVisitor(Integer index) {
            this.index = index;
        }

        @Override
        public void visitAllOfSchema(OasSchema node) {
            OasSchema parentSchema = (OasSchema)node.parent();
            parentSchema.restoreAllOfSchema(this.index, node);
        }

        @Override
        public void visitAnyOfSchema(Oas30Schema.Oas30AnyOfSchema node) {
            Oas30Schema parentSchema = (Oas30Schema)node.parent();
            parentSchema.restoreAnyOfSchema(this.index, node);
        }

        @Override
        public void visitOneOfSchema(Oas30Schema.Oas30OneOfSchema node) {
            Oas30Schema parentSchema = (Oas30Schema)node.parent();
            parentSchema.restoreOneOfSchema(this.index, node);
        }
    }

    private static class SchemaRemoverVisitor
    extends CombinedVisitorAdapter {
        public String type;
        public int index;

        private SchemaRemoverVisitor() {
        }

        @Override
        public void visitAllOfSchema(OasSchema node) {
            OasSchema parentSchema = (OasSchema)node.parent();
            this.index = parentSchema.allOf.indexOf(node);
            parentSchema.removeAllOfSchema(node);
            this.type = "allOf";
        }

        @Override
        public void visitAnyOfSchema(Oas30Schema.Oas30AnyOfSchema node) {
            Oas30Schema parentSchema = (Oas30Schema)node.parent();
            this.index = parentSchema.anyOf.indexOf(node);
            parentSchema.removeAnyOfSchema(node);
            this.type = "anyOf";
        }

        @Override
        public void visitOneOfSchema(Oas30Schema.Oas30OneOfSchema node) {
            Oas30Schema parentSchema = (Oas30Schema)node.parent();
            this.index = parentSchema.oneOf.indexOf(node);
            parentSchema.removeOneOfSchema(node);
            this.type = "oneOf";
        }
    }
}

