/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.models.OasResponses;

public class DeleteResponseCommand
extends AbstractCommand {
    public String _responseCode;
    public NodePath _responsePath;
    public NodePath _responsesPath;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldResponse;
    public Integer _oldResponseIndex;

    DeleteResponseCommand() {
    }

    DeleteResponseCommand(OasResponse response) {
        this._responseCode = response.getStatusCode();
        this._responsePath = Library.createNodePath(response);
        this._responsesPath = Library.createNodePath(response.parent());
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteResponseCommand] Executing.", new Object[0]);
        this._oldResponse = null;
        OasResponse response = (OasResponse)this._responsePath.resolve(document);
        if (this.isNullOrUndefined(response)) {
            return;
        }
        OasResponses responses = (OasResponses)response.parent();
        if (this.isNullOrUndefined(this._responseCode)) {
            responses.default_ = null;
            this._oldResponseIndex = 0;
        } else {
            this._oldResponseIndex = responses.getResponses().indexOf(response);
            responses.removeResponse(this._responseCode);
        }
        this._oldResponse = Library.writeNode(response);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteResponseCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldResponse)) {
            return;
        }
        OasResponses responses = (OasResponses)this._responsesPath.resolve(document);
        if (this.isNullOrUndefined(responses)) {
            return;
        }
        OasResponse response = responses.createResponse(this._responseCode);
        Library.readNode(this._oldResponse, response);
        responses.restoreResponse(this._oldResponseIndex, this._responseCode, response);
    }
}

