/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.commands.DeleteSecuritySchemeCommand;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityDefinitions;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityScheme;

public class DeleteSecuritySchemeCommand_20
extends DeleteSecuritySchemeCommand {
    public Integer _oldSchemeIndex;

    DeleteSecuritySchemeCommand_20() {
    }

    DeleteSecuritySchemeCommand_20(String schemeName) {
        super(schemeName);
    }

    @Override
    protected Object doDeleteScheme(Document document) {
        Oas20Document doc20 = (Oas20Document)document;
        Oas20SecurityDefinitions definitions = doc20.securityDefinitions;
        if (this.isNullOrUndefined(definitions)) {
            return null;
        }
        this._oldSchemeIndex = definitions.getItemNames().indexOf(this._schemeName);
        return Library.writeNode(definitions.removeSecurityScheme(this._schemeName));
    }

    @Override
    protected void doRestoreScheme(Document document, Object oldScheme) {
        Oas20Document doc20 = (Oas20Document)document;
        Oas20SecurityDefinitions definitions = doc20.securityDefinitions;
        if (this.isNullOrUndefined(definitions) || this.isNullOrUndefined(oldScheme)) {
            return;
        }
        Oas20SecurityScheme scheme = definitions.createSecurityScheme(this._schemeName);
        Library.readNode(oldScheme, scheme);
        definitions.restoreSecurityScheme(this._oldSchemeIndex, this._schemeName, scheme);
    }
}

