/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiSecurityScheme;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Document;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20NodeFactory;
import io.apicurio.datamodels.cmd.commands.DeleteSecuritySchemeCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.core.models.Document;

public class DeleteSecuritySchemeCommand_Aai20
extends DeleteSecuritySchemeCommand {
    public Integer _oldSchemeIndex;

    DeleteSecuritySchemeCommand_Aai20() {
    }

    DeleteSecuritySchemeCommand_Aai20(String schemeName) {
        super(schemeName);
    }

    @Override
    protected Object doDeleteScheme(Document document) {
        Aai20Document aai20Document = (Aai20Document)document;
        if (ModelUtils.isDefined(aai20Document.components)) {
            this._oldSchemeIndex = aai20Document.components.getSecuritySchemesNames().indexOf(this._schemeName);
            return Library.writeNode(aai20Document.components.removeSecurityScheme(this._schemeName));
        }
        return null;
    }

    @Override
    protected void doRestoreScheme(Document document, Object oldScheme) {
        Aai20Document aai20Document = (Aai20Document)document;
        if (ModelUtils.isDefined(aai20Document.components)) {
            AaiSecurityScheme scheme = new Aai20NodeFactory().createSecurityScheme(aai20Document.components, this._schemeName);
            Library.readNode(oldScheme, scheme);
            aai20Document.components.restoreSecurityScheme(this._oldSchemeIndex, this._schemeName, scheme);
        }
    }
}

