/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasResponse;

public class NewResponseCommand
extends AbstractCommand {
    public NodePath _operationPath;
    public String _statusCode;
    public boolean _created;
    public boolean _nullResponses;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object sourceResponse;

    NewResponseCommand() {
    }

    NewResponseCommand(OasOperation operation, String statusCode, OasResponse sourceResponse) {
        this._operationPath = Library.createNodePath(operation);
        this._statusCode = statusCode;
        if (ModelUtils.isDefined(sourceResponse)) {
            this.sourceResponse = Library.writeNode(sourceResponse);
        }
    }

    @Override
    public void execute(Document document) {
        OasResponse response;
        LoggerCompat.info("[NewResponseCommand] Executing.  Status Code=%s", this._statusCode);
        this._created = false;
        this._nullResponses = false;
        OasOperation operation = (OasOperation)this._operationPath.resolve(document);
        if (this.isNullOrUndefined(operation)) {
            return;
        }
        if (this.isNullOrUndefined(operation.responses)) {
            operation.responses = operation.createResponses();
            this._nullResponses = true;
        }
        if (this.isNullOrUndefined(response = operation.responses.getResponse(this._statusCode))) {
            response = operation.responses.createResponse(this._statusCode);
            if (ModelUtils.isDefined(this.sourceResponse)) {
                Library.readNode(this.sourceResponse, response);
            }
            operation.responses.addResponse(this._statusCode, response);
            this._created = true;
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewResponseCommand] Reverting.", new Object[0]);
        OasOperation operation = (OasOperation)this._operationPath.resolve(document);
        if (this.isNullOrUndefined(operation)) {
            return;
        }
        if (this._nullResponses) {
            operation.responses = null;
            return;
        }
        if (!this._created) {
            return;
        }
        operation.responses.removeResponse(this._statusCode);
    }
}

