/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.IOasHeaderParent;
import io.apicurio.datamodels.openapi.models.OasHeader;

public class RenameHeaderCommand
extends AbstractCommand {
    public NodePath _parentPath;
    public String _oldHeaderName;
    public String _newHeaderName;

    RenameHeaderCommand() {
    }

    RenameHeaderCommand(OasHeader parent, String oldHeaderName, String newHeaderName) {
        this._oldHeaderName = oldHeaderName;
        this._newHeaderName = newHeaderName;
        this._parentPath = Library.createNodePath(parent);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[RenameHeaderCommand] Executing.", new Object[0]);
        this._doHeaderRename(document, this._oldHeaderName, this._newHeaderName);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[RenameHeaderCommand] Reverting.", new Object[0]);
        this._doHeaderRename(document, this._newHeaderName, this._oldHeaderName);
    }

    private void _doHeaderRename(Document document, String from, String to) {
        IOasHeaderParent parent = (IOasHeaderParent)((Object)this._parentPath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        if (!this.isNullOrUndefined(parent.getHeader(to))) {
            return;
        }
        parent.renameHeader(from, to, header -> header.rename(to));
    }
}

