/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;

public abstract class ReplaceNodeCommand<T extends Node>
extends AbstractCommand {
    public NodePath _nodePath;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _new;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _old;

    ReplaceNodeCommand() {
    }

    ReplaceNodeCommand(T old, T replacement) {
        this._nodePath = Library.createNodePath(old);
        this._new = Library.writeNode(replacement);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[ReplaceNodeCommand] Executing.", new Object[0]);
        this._old = null;
        Node oldNode = this._nodePath.resolve(document);
        if (this.isNullOrUndefined(oldNode)) {
            return;
        }
        this._old = Library.writeNode(oldNode);
        T newNode = this.readNode(document, this._new);
        this.replaceNode(document, newNode);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ReplaceNodeCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._old)) {
            return;
        }
        Node node = this._nodePath.resolve(document);
        if (this.isNullOrUndefined(node)) {
            return;
        }
        T restoreNode = this.readNode(document, this._old);
        this.replaceNode(document, restoreNode);
    }

    protected abstract void replaceNode(Document var1, T var2);

    protected abstract T readNode(Document var1, Object var2);
}

