/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.visitors;

import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.ValidationProblem;
import io.apicurio.datamodels.core.models.common.Contact;
import io.apicurio.datamodels.core.models.common.ExternalDocumentation;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.models.common.Info;
import io.apicurio.datamodels.core.models.common.License;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.core.models.common.SecurityRequirement;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.core.models.common.Tag;
import io.apicurio.datamodels.core.visitors.IVisitor;

public class NodePathVisitor
implements IVisitor {
    protected NodePath path = new NodePath();

    public NodePath getPath() {
        return this.path;
    }

    @Override
    public void visitValidationProblem(ValidationProblem problem) {
    }

    @Override
    public void visitDocument(Document node) {
    }

    @Override
    public void visitExtension(Extension node) {
        this.path.prependSegment(node.name, false);
    }

    @Override
    public void visitInfo(Info node) {
        this.path.prependSegment("info", false);
    }

    @Override
    public void visitContact(Contact node) {
        this.path.prependSegment("contact", false);
    }

    @Override
    public void visitLicense(License node) {
        this.path.prependSegment("license", false);
    }

    @Override
    public void visitTag(Tag node) {
        int idx = NodeCompat.indexOf(node, node.parent(), "tags");
        if (idx != -1) {
            this.path.prependSegment(String.valueOf(idx), true);
            this.path.prependSegment("tags", false);
        }
    }

    @Override
    public void visitSecurityRequirement(SecurityRequirement node) {
        int idx = NodeCompat.indexOf(node, node.parent(), "security");
        if (idx != -1) {
            this.path.prependSegment(String.valueOf(idx), true);
            this.path.prependSegment("security", false);
        }
    }

    @Override
    public void visitExternalDocumentation(ExternalDocumentation node) {
        this.path.prependSegment("externalDocs", false);
    }

    @Override
    public void visitSchema(Schema node) {
        this.path.prependSegment("schema", false);
    }

    @Override
    public void visitParameter(Parameter node) {
        int idx = NodeCompat.indexOf(node, node.parent(), "parameters");
        if (idx != -1) {
            this.path.prependSegment(String.valueOf(idx), true);
            this.path.prependSegment("parameters", false);
        }
    }

    @Override
    public void visitOperation(Operation node) {
        this.path.prependSegment(node.getType(), false);
    }

    @Override
    public void visitSecurityScheme(SecurityScheme node) {
        this.path.prependSegment(node.getSchemeName(), true);
    }

    @Override
    public void visitSchemaDefinition(IDefinition node) {
        this.path.prependSegment(node.getName(), true);
    }

    @Override
    public void visitParameterDefinition(IDefinition node) {
        this.path.prependSegment(node.getName(), true);
    }
}

