/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.models;

import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.common.ExternalDocumentation;
import io.apicurio.datamodels.core.models.common.IExternalDocumentationParent;
import io.apicurio.datamodels.core.models.common.IPropertyParent;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.openapi.models.OasXML;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public abstract class OasSchema
extends Schema
implements IExternalDocumentationParent,
IPropertyParent {
    public String format;
    public String title;
    public String description;
    public Object default_;
    public Number multipleOf;
    public Number maximum;
    public Boolean exclusiveMaximum;
    public Number minimum;
    public Boolean exclusiveMinimum;
    public Number maxLength;
    public Number minLength;
    public String pattern;
    public Number maxItems;
    public Number minItems;
    public Boolean uniqueItems;
    public Number maxProperties;
    public Number minProperties;
    public List<String> required;
    public List<String> enum_;
    public String type;
    public Object items;
    public List<OasSchema> allOf;
    public Map<String, OasSchema> properties;
    public Object additionalProperties;
    public Boolean readOnly;
    public OasXML xml;
    public ExternalDocumentation externalDocs;
    public Object example;

    @Override
    public abstract ExternalDocumentation createExternalDocumentation();

    @Override
    public void setExternalDocumentation(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
    }

    public abstract OasXML createXML();

    public abstract OasSchema createAllOfSchema();

    public abstract OasSchema createItemsSchema();

    public abstract OasSchema createAdditionalPropertiesSchema();

    @Override
    public abstract Schema createPropertySchema(String var1);

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> rval = new ArrayList<String>();
        if (ModelUtils.isDefined(this.properties)) {
            rval.addAll(this.properties.keySet());
        }
        return rval;
    }

    @Override
    public List<Schema> getProperties() {
        ArrayList<Schema> rval = new ArrayList<Schema>();
        if (ModelUtils.isDefined(this.properties)) {
            rval.addAll(this.properties.values());
        }
        return rval;
    }

    @Override
    public Schema addProperty(String propertyName, Schema schema) {
        if (ModelUtils.isNullOrUndefined(this.properties)) {
            this.properties = new LinkedHashMap<String, OasSchema>();
        }
        this.properties.put(propertyName, (OasSchema)schema);
        return schema;
    }

    @Override
    public Schema removeProperty(String propertyName) {
        if (ModelUtils.isDefined(this.properties)) {
            return this.properties.remove(propertyName);
        }
        return null;
    }

    @Override
    public void renameProperty(String oldPropertyName, String newPropertyName, Consumer<Schema> propertyConsumer) {
        this.properties = ModelUtils.renameMapKey(oldPropertyName, newPropertyName, this.properties, propertyConsumer);
    }

    @Override
    public void restoreProperty(Integer index, String propertyName, Schema schema) {
        this.properties = ModelUtils.restoreMapEntry(index, propertyName, (OasSchema)schema, this.properties);
    }

    @Override
    public Schema getProperty(String propertyName) {
        if (ModelUtils.isDefined(this.properties)) {
            return this.properties.get(propertyName);
        }
        return null;
    }

    @Override
    public List<String> getRequiredProperties() {
        return this.required;
    }

    @Override
    public void setRequiredProperties(List<String> requiredProperties) {
        this.required = requiredProperties;
    }

    @Override
    public boolean isPropertyRequired(String propertyName) {
        if (ModelUtils.isDefined(this.required)) {
            return this.required.contains(propertyName);
        }
        return false;
    }

    @Override
    public void setPropertyRequired(String propertyName) {
        if (ModelUtils.isNullOrUndefined(this.required)) {
            this.required = new ArrayList<String>();
        }
        if (!this.required.contains(propertyName)) {
            this.required.add(propertyName);
        }
    }

    @Override
    public void unsetPropertyRequired(String propertyName) {
        if (ModelUtils.isDefined(this.required)) {
            this.required.remove(propertyName);
            if (this.required.isEmpty()) {
                this.required = null;
            }
        }
    }

    public boolean hasItemsSchema() {
        return NodeCompat.isNode(this.items);
    }

    public boolean hasItemsSchemas() {
        return NodeCompat.isList(this.items);
    }

    public boolean hasAdditionalPropertiesSchema() {
        return NodeCompat.isNode(this.additionalProperties);
    }

    public boolean hasAdditionalPropertiesBoolean() {
        return this.additionalProperties != null && !NodeCompat.isNode(this.additionalProperties);
    }

    public void addAllOfSchema(OasSchema schema) {
        if (this.allOf == null) {
            this.allOf = new ArrayList<OasSchema>();
        }
        this.allOf.add(schema);
    }

    public void removeAllOfSchema(OasSchema schema) {
        if (this.allOf != null) {
            this.allOf.remove(schema);
        }
    }

    public void restoreAllOfSchema(Integer index, OasSchema schema) {
        this.allOf = ModelUtils.restoreListEntry(index, schema, this.allOf);
    }
}

