/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.v2.models;

import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.core.models.IIndexedNode;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.visitors.IVisitor;
import io.apicurio.datamodels.openapi.v2.models.Oas20ResponseDefinition;
import io.apicurio.datamodels.openapi.v2.visitors.IOas20Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class Oas20ResponseDefinitions
extends Node
implements IIndexedNode<Oas20ResponseDefinition> {
    public Map<String, Oas20ResponseDefinition> items = new LinkedHashMap<String, Oas20ResponseDefinition>();

    @Override
    public void accept(IVisitor visitor) {
        IOas20Visitor viz = (IOas20Visitor)visitor;
        viz.visitResponseDefinitions(this);
    }

    public Oas20ResponseDefinition getResponse(String name) {
        return this.items.get(name);
    }

    public List<Oas20ResponseDefinition> getResponses() {
        ArrayList<Oas20ResponseDefinition> rval = new ArrayList<Oas20ResponseDefinition>();
        rval.addAll(this.items.values());
        return rval;
    }

    public Oas20ResponseDefinition addResponse(String name, Oas20ResponseDefinition response) {
        this.items.put(name, response);
        return response;
    }

    public Oas20ResponseDefinition replaceResponse(Oas20ResponseDefinition newResponse) {
        this.addResponse(newResponse.getName(), newResponse);
        return newResponse;
    }

    public void renameResponse(String fromName, String toName, Consumer<Oas20ResponseDefinition> responseConsumer) {
        this.items = ModelUtils.renameMapKey(fromName, toName, this.items, responseConsumer);
    }

    public Oas20ResponseDefinition removeResponse(String name) {
        return this.items.remove(name);
    }

    public void restoreResponseDefinition(Integer index, String name, Oas20ResponseDefinition schemaDef) {
        this.items = ModelUtils.restoreMapEntry(index, name, schemaDef, this.items);
    }

    public List<String> getResponseNames() {
        ArrayList<String> rval = new ArrayList<String>();
        rval.addAll(this.items.keySet());
        return rval;
    }

    public Oas20ResponseDefinition createResponse(String name) {
        Oas20ResponseDefinition rval = new Oas20ResponseDefinition(name);
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }

    @Override
    public Oas20ResponseDefinition getItem(String name) {
        return this.getResponse(name);
    }

    @Override
    public List<Oas20ResponseDefinition> getItems() {
        return this.getResponses();
    }

    @Override
    public List<String> getItemNames() {
        return this.getResponseNames();
    }

    @Override
    public void addItem(String name, Oas20ResponseDefinition item) {
        this.addResponse(name, item);
    }

    @Override
    public Oas20ResponseDefinition deleteItem(String name) {
        return this.removeResponse(name);
    }
}

