/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.v3.models;

import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.common.IServerParent;
import io.apicurio.datamodels.core.models.common.Server;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.v3.models.Oas30Operation;
import io.apicurio.datamodels.openapi.v3.models.Oas30Parameter;
import io.apicurio.datamodels.openapi.v3.models.Oas30Server;
import java.util.ArrayList;
import java.util.List;

public class Oas30PathItem
extends OasPathItem
implements IServerParent {
    public String summary;
    public String description;
    public Oas30Operation trace;
    public List<Server> servers;

    public Oas30PathItem(String path) {
        super(path);
    }

    @Override
    public OasOperation createOperation(String method) {
        Oas30Operation rval = new Oas30Operation(method);
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }

    @Override
    public OasParameter createParameter() {
        Oas30Parameter rval = new Oas30Parameter();
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }

    @Override
    public Server createServer() {
        Oas30Server rval = new Oas30Server();
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }

    public void addServer(Oas30Server server) {
        if (this.servers == null) {
            this.servers = new ArrayList<Server>();
        }
        this.servers.add(server);
    }

    @Override
    public void restoreServer(Integer index, Server server) {
        this.servers = ModelUtils.restoreListEntry(index, server, this.servers);
    }

    @Override
    public List<Server> getServers() {
        return this.servers;
    }

    @Override
    public void setOperation(OasOperation operation) {
        if (NodeCompat.equals("trace", operation.getMethod())) {
            this.trace = (Oas30Operation)operation;
        } else {
            super.setOperation(operation);
        }
    }

    @Override
    public void addServer(Server server) {
        if (this.servers == null) {
            this.servers = new ArrayList<Server>();
        }
        this.servers.add((Oas30Server)server);
    }

    @Override
    public Server getServer(String url) {
        if (this.servers != null) {
            for (Server server : this.servers) {
                if (!NodeCompat.equals(server.url, url)) continue;
                return server;
            }
        }
        return null;
    }
}

