/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.v3.models;

import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.openapi.models.IOasHeaderParent;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.v3.models.IOas30MediaTypeParent;
import io.apicurio.datamodels.openapi.v3.models.Oas30Header;
import io.apicurio.datamodels.openapi.v3.models.Oas30Link;
import io.apicurio.datamodels.openapi.v3.models.Oas30MediaType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class Oas30Response
extends OasResponse
implements IOas30MediaTypeParent,
IOasHeaderParent {
    public Map<String, Oas30Header> headers = new LinkedHashMap<String, Oas30Header>();
    public Map<String, Oas30MediaType> content = new LinkedHashMap<String, Oas30MediaType>();
    public Map<String, Oas30Link> links = new LinkedHashMap<String, Oas30Link>();

    public Oas30Response(String statusCode) {
        super(statusCode);
    }

    @Override
    public String getStatusCode() {
        return this.getName();
    }

    @Override
    public Oas30MediaType createMediaType(String name) {
        Oas30MediaType rval = new Oas30MediaType(name);
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }

    @Override
    public void addMediaType(String name, Oas30MediaType mediaType) {
        this.content.put(name, mediaType);
    }

    @Override
    public Oas30MediaType getMediaType(String name) {
        return this.content.get(name);
    }

    @Override
    public Oas30MediaType removeMediaType(String name) {
        return this.content.remove(name);
    }

    @Override
    public List<Oas30MediaType> getMediaTypes() {
        ArrayList<Oas30MediaType> rval = new ArrayList<Oas30MediaType>();
        rval.addAll(this.content.values());
        return rval;
    }

    @Override
    public void restoreMediaType(Integer index, String name, Oas30MediaType mediaType) {
        this.content = ModelUtils.restoreMapEntry(index, name, mediaType, this.content);
    }

    public Oas30Link createLink(String name) {
        Oas30Link rval = new Oas30Link(name);
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }

    public void addLink(String name, Oas30Link link) {
        this.links.put(name, link);
    }

    public Oas30Link getLink(String name) {
        return this.links.get(name);
    }

    public Oas30Link removeLink(String name) {
        return this.links.remove(name);
    }

    public List<Oas30Link> getLinks() {
        ArrayList<Oas30Link> rval = new ArrayList<Oas30Link>();
        rval.addAll(this.links.values());
        return rval;
    }

    @Override
    public Oas30Header createHeader(String name) {
        Oas30Header rval = new Oas30Header(name);
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }

    @Override
    public void addHeader(String name, OasHeader header) {
        this.headers.put(name, (Oas30Header)header);
    }

    @Override
    public OasHeader getHeader(String name) {
        return this.headers.get(name);
    }

    @Override
    public OasHeader removeHeader(String name) {
        return this.headers.remove(name);
    }

    @Override
    public void renameHeader(String from, String to, Consumer<OasHeader> headerConsumer) {
        this.headers = ModelUtils.renameMapKey(from, to, this.headers, headerConsumer);
    }

    @Override
    public void replaceHeader(String name, OasHeader header) {
        this.addHeader(name, header);
    }

    @Override
    public void restoreHeader(Integer index, String headerName, OasHeader header) {
        this.headers = ModelUtils.restoreMapEntry(index, headerName, (Oas30Header)header, this.headers);
    }

    @Override
    public List<OasHeader> getHeaders() {
        ArrayList<OasHeader> rval = new ArrayList<OasHeader>();
        rval.addAll(this.headers.values());
        return rval;
    }
}

