/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.models;

import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.common.ISecurityRequirementParent;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.SecurityRequirement;
import io.apicurio.datamodels.openapi.models.IOasParameterParent;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasResponses;
import io.apicurio.datamodels.openapi.models.OasSecurityRequirement;
import java.util.ArrayList;
import java.util.List;

public abstract class OasOperation
extends Operation
implements IOasParameterParent,
ISecurityRequirementParent {
    public List<String> tags;
    public List<OasParameter> parameters;
    public OasResponses responses;
    public Boolean deprecated;
    public List<SecurityRequirement> security;

    public OasOperation(String method) {
        super(method);
    }

    @Override
    public List<OasParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public List<OasParameter> getParametersIn(String in) {
        ArrayList<OasParameter> params = new ArrayList<OasParameter>();
        if (ModelUtils.isDefined(this.parameters)) {
            this.parameters.forEach(param -> {
                if (NodeCompat.equals(param.in, in)) {
                    params.add((OasParameter)param);
                }
            });
        }
        return params;
    }

    public String getMethod() {
        return this.getType();
    }

    @Override
    public abstract OasParameter createParameter();

    @Override
    public OasParameter getParameter(String in, String name) {
        OasParameter rval = null;
        if (this.parameters != null) {
            for (OasParameter parameter : this.parameters) {
                if (!NodeCompat.equals(parameter.in, in) || !NodeCompat.equals(parameter.name, name)) continue;
                rval = parameter;
            }
        }
        return rval;
    }

    @Override
    public OasParameter addParameter(OasParameter parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<OasParameter>();
        }
        this.parameters.add(parameter);
        return parameter;
    }

    public abstract OasResponses createResponses();

    @Override
    public abstract OasSecurityRequirement createSecurityRequirement();

    @Override
    public SecurityRequirement addSecurityRequirement(SecurityRequirement securityRequirement) {
        if (this.security == null) {
            this.security = new ArrayList<SecurityRequirement>();
        }
        this.security.add(securityRequirement);
        return securityRequirement;
    }

    @Override
    public List<SecurityRequirement> getSecurityRequirements() {
        return this.security;
    }
}

