/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.visitors;

import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.models.common.IExample;
import io.apicurio.datamodels.core.visitors.NodePathVisitor;
import io.apicurio.datamodels.openapi.models.IOasPropertySchema;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasPaths;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.models.OasResponses;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.models.OasXML;
import io.apicurio.datamodels.openapi.visitors.IOasVisitor;

public class OasNodePathVisitor
extends NodePathVisitor
implements IOasVisitor {
    @Override
    public void visitPaths(OasPaths node) {
        this.path.prependSegment("paths", false);
    }

    @Override
    public void visitPathItem(OasPathItem node) {
        this.path.prependSegment(node.getPath(), true);
    }

    @Override
    public void visitResponses(OasResponses node) {
        this.path.prependSegment("responses", false);
    }

    @Override
    public void visitResponse(OasResponse node) {
        if (node.getName() == null) {
            this.path.prependSegment("default", false);
        } else {
            this.path.prependSegment(node.getName(), true);
        }
    }

    @Override
    public void visitXML(OasXML node) {
        this.path.prependSegment("xml", false);
    }

    @Override
    public void visitAllOfSchema(OasSchema node) {
        int idx = NodeCompat.indexOf(node, node.parent(), "allOf");
        if (idx != -1) {
            this.path.prependSegment(String.valueOf(idx), true);
            this.path.prependSegment("allOf", false);
        }
    }

    @Override
    public void visitItemsSchema(OasSchema node) {
        if (node.hasItemsSchemas()) {
            int idx = NodeCompat.indexOf(node, node.parent(), "items");
            if (idx != -1) {
                this.path.prependSegment(String.valueOf(idx), true);
                this.path.prependSegment("items", false);
            }
        } else {
            this.path.prependSegment("items", false);
        }
    }

    @Override
    public void visitAdditionalPropertiesSchema(OasSchema node) {
        this.path.prependSegment("additionalProperties", false);
    }

    @Override
    public void visitPropertySchema(IOasPropertySchema node) {
        this.path.prependSegment(node.getPropertyName(), true);
        this.path.prependSegment("properties", false);
    }

    @Override
    public void visitHeader(OasHeader node) {
        this.path.prependSegment(node.getName(), true);
    }

    @Override
    public void visitResponseDefinition(IDefinition node) {
        this.path.prependSegment(node.getName(), true);
    }

    @Override
    public void visitExample(IExample node) {
        throw new RuntimeException("Must be implemented by subclasses.");
    }
}

