/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.models.openapi.v20;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.NodeImpl;
import io.apicurio.datamodels.models.openapi.OpenApiPathItem;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20PathItem;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20PathItemImpl;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Paths;
import io.apicurio.datamodels.models.openapi.v20.visitors.OpenApi20Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OpenApi20PathsImpl
extends NodeImpl
implements OpenApi20Paths {
    private Map<String, JsonNode> extensions;
    private Map<String, OpenApiPathItem> _items = new LinkedHashMap<String, OpenApiPathItem>();

    @Override
    public Map<String, JsonNode> getExtensions() {
        return this.extensions;
    }

    @Override
    public void addExtension(String name, JsonNode value) {
        if (this.extensions == null) {
            this.extensions = new LinkedHashMap<String, JsonNode>();
        }
        this.extensions.put(name, value);
    }

    @Override
    public void clearExtensions() {
        if (this.extensions != null) {
            this.extensions.clear();
        }
    }

    @Override
    public void removeExtension(String name) {
        if (this.extensions != null) {
            this.extensions.remove(name);
        }
    }

    @Override
    public OpenApiPathItem getItem(String name) {
        return this._items.get(name);
    }

    @Override
    public List<OpenApiPathItem> getItems() {
        ArrayList<OpenApiPathItem> rval = new ArrayList<OpenApiPathItem>();
        rval.addAll(this._items.values());
        return rval;
    }

    @Override
    public List<String> getItemNames() {
        ArrayList<String> rval = new ArrayList<String>();
        rval.addAll(this._items.keySet());
        return rval;
    }

    @Override
    public void addItem(String name, OpenApiPathItem item) {
        this._items.put(name, item);
    }

    @Override
    public OpenApiPathItem removeItem(String name) {
        return this._items.remove(name);
    }

    @Override
    public OpenApi20PathItem createPathItem() {
        OpenApi20PathItemImpl node = new OpenApi20PathItemImpl();
        node.setParent(this);
        node.setRoot(this.root());
        return node;
    }

    @Override
    public void accept(Visitor visitor) {
        OpenApi20Visitor viz = (OpenApi20Visitor)visitor;
        viz.visitPaths(this);
    }

    @Override
    public Node emptyClone() {
        return new OpenApi20PathsImpl();
    }
}

