/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.models.openapi.v30;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.NodeImpl;
import io.apicurio.datamodels.models.openapi.OpenApiHeader;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Encoding;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Header;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30HeaderImpl;
import io.apicurio.datamodels.models.openapi.v30.visitors.OpenApi30Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.LinkedHashMap;
import java.util.Map;

public class OpenApi30EncodingImpl
extends NodeImpl
implements OpenApi30Encoding {
    private String contentType;
    private Map<String, OpenApiHeader> headers;
    private String style;
    private Boolean explode;
    private Boolean allowReserved;
    private Map<String, JsonNode> extensions;

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setContentType(String value) {
        this.contentType = value;
    }

    @Override
    public OpenApi30Header createHeader() {
        OpenApi30HeaderImpl node = new OpenApi30HeaderImpl();
        node.setParent(this);
        node.setRoot(this.root());
        return node;
    }

    @Override
    public Map<String, OpenApiHeader> getHeaders() {
        return this.headers;
    }

    @Override
    public void addHeader(String name, OpenApiHeader value) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, OpenApiHeader>();
        }
        this.headers.put(name, value);
    }

    @Override
    public void clearHeaders() {
        if (this.headers != null) {
            this.headers.clear();
        }
    }

    @Override
    public void removeHeader(String name) {
        if (this.headers != null) {
            this.headers.remove(name);
        }
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(String value) {
        this.style = value;
    }

    @Override
    public Boolean isExplode() {
        return this.explode;
    }

    @Override
    public void setExplode(Boolean value) {
        this.explode = value;
    }

    @Override
    public Boolean isAllowReserved() {
        return this.allowReserved;
    }

    @Override
    public void setAllowReserved(Boolean value) {
        this.allowReserved = value;
    }

    @Override
    public Map<String, JsonNode> getExtensions() {
        return this.extensions;
    }

    @Override
    public void addExtension(String name, JsonNode value) {
        if (this.extensions == null) {
            this.extensions = new LinkedHashMap<String, JsonNode>();
        }
        this.extensions.put(name, value);
    }

    @Override
    public void clearExtensions() {
        if (this.extensions != null) {
            this.extensions.clear();
        }
    }

    @Override
    public void removeExtension(String name) {
        if (this.extensions != null) {
            this.extensions.remove(name);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        OpenApi30Visitor viz = (OpenApi30Visitor)visitor;
        viz.visitEncoding(this);
    }

    @Override
    public Node emptyClone() {
        return new OpenApi30EncodingImpl();
    }
}

