/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.name;

import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.openapi.OpenApiEncoding;
import io.apicurio.datamodels.models.openapi.OpenApiSchema;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30MediaType;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.invalid.name.OasInvalidPropertyNameRule;

public class OasUnmatchedEncodingPropertyRule
extends OasInvalidPropertyNameRule {
    public OasUnmatchedEncodingPropertyRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private boolean isValidSchemaProperty(Schema schema, String propertyName) {
        if (this.isNullOrUndefined(schema) && this.isNullOrUndefined(schema.getProperties())) {
            return false;
        }
        return !this.isNullOrUndefined(schema.getProperties().get(propertyName));
    }

    @Override
    public void visitEncoding(OpenApiEncoding node) {
        String name = this.getEncodingName(node);
        OpenApiSchema schema = ((OpenApi30MediaType)node.parent()).getSchema();
        this.reportIfInvalid(this.isValidSchemaProperty(schema, name), node, name, this.map("name", name));
    }
}

