/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.format;

import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Document;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;

public class OasInvalidApiHostRule
extends ValidationRule {
    public OasInvalidApiHostRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    public static boolean isValidHost(String propertyValue) {
        return propertyValue.indexOf("http:") != 0 && propertyValue.indexOf("https:") != 0;
    }

    @Override
    public void visitDocument(Document node) {
        OpenApi20Document doc = (OpenApi20Document)node;
        if (this.hasValue(doc.getHost())) {
            this.reportIfInvalid(OasInvalidApiHostRule.isValidHost(doc.getHost()), doc, "host", this.map(new String[0]));
        }
    }
}

