/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.visitors;

import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.Visitable;
import io.apicurio.datamodels.models.visitors.AllNodeVisitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.ArrayList;
import java.util.List;

public class CompositeAllNodeVisitor
extends AllNodeVisitor {
    private List<Visitor> visitors = new ArrayList<Visitor>();

    public CompositeAllNodeVisitor(List<Visitor> visitors) {
        this.visitors = visitors;
    }

    public void addVisitor(Visitor visitor) {
        this.visitors.add(visitor);
    }

    public void addVisitors(List<? extends Visitor> visitors) {
        this.visitors.addAll(visitors);
    }

    public List<? extends Visitor> getVisitors() {
        return this.visitors;
    }

    protected void acceptAll(Visitable node) {
        this.visitors.forEach(visitor -> node.accept((Visitor)visitor));
    }

    @Override
    protected void visitNode(Node node) {
        this.acceptAll(node);
    }
}

