/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.models.visitors;

import io.apicurio.datamodels.models.MappedNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.Visitable;
import io.apicurio.datamodels.models.union.EntityListUnionValue;
import io.apicurio.datamodels.models.union.EntityMapUnionValue;
import io.apicurio.datamodels.models.union.Union;
import io.apicurio.datamodels.models.util.JsonUtil;
import io.apicurio.datamodels.models.visitors.TraversalContextImpl;
import io.apicurio.datamodels.models.visitors.Traverser;
import io.apicurio.datamodels.models.visitors.TraversingVisitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.Collection;
import java.util.Map;

public abstract class AbstractTraverser
implements Traverser,
Visitor {
    protected final Visitor visitor;
    protected final TraversalContextImpl traversalContext = new TraversalContextImpl();

    public AbstractTraverser(Visitor visitor) {
        this.visitor = visitor;
        if (visitor instanceof TraversingVisitor) {
            ((TraversingVisitor)((Object)visitor)).setTraversalContext(this.traversalContext);
        }
    }

    protected void doTraverseNode(Visitable node) {
        node.accept(this);
    }

    protected void traverseNode(String propertyName, Visitable node) {
        if (node != null) {
            this.traversalContext.pushProperty(propertyName);
            this.doTraverseNode(node);
            this.traversalContext.pop();
        }
    }

    protected void traverseList(String propertyName, Collection<? extends Node> items) {
        if (items != null) {
            int index = 0;
            this.traversalContext.pushProperty(propertyName);
            Collection<Node> clonedItems = JsonUtil.cloneCollection(items);
            for (Node node : clonedItems) {
                if (node != null) {
                    this.traversalContext.pushListIndex(index);
                    this.doTraverseNode(node);
                    this.traversalContext.pop();
                }
                ++index;
            }
            this.traversalContext.pop();
        }
    }

    protected void traverseMap(String propertyName, Map<String, ? extends Node> items) {
        if (items != null) {
            this.traversalContext.pushProperty(propertyName);
            Collection<?> keys = JsonUtil.cloneCollection(items.keySet());
            keys.forEach(key -> {
                Node value = (Node)items.get(key);
                if (value != null) {
                    this.traversalContext.pushMapIndex((String)key);
                    this.doTraverseNode(value);
                    this.traversalContext.pop();
                }
            });
            this.traversalContext.pop();
        }
    }

    protected void traverseMappedNode(MappedNode<? extends Node> mappedNode) {
        if (mappedNode != null) {
            Collection<?> names = JsonUtil.cloneCollection(mappedNode.getItemNames());
            names.forEach(name -> {
                Node value = (Node)mappedNode.getItem((String)name);
                if (value != null) {
                    this.traversalContext.pushMapIndex((String)name);
                    this.doTraverseNode(value);
                    this.traversalContext.pop();
                }
            });
        }
    }

    protected void traverseUnion(String propertyName, Union union) {
        if (union != null) {
            if (union.isEntity()) {
                this.traverseNode(propertyName, union);
            } else if (union.isEntityList()) {
                EntityListUnionValue value = (EntityListUnionValue)((Object)union);
                this.traverseList(propertyName, (Collection)value.getValue());
            } else if (union.isEntityMap()) {
                EntityMapUnionValue value = (EntityMapUnionValue)((Object)union);
                this.traverseMap(propertyName, (Map)value.getValue());
            }
        }
    }

    @Override
    public void traverse(Node node) {
        node.accept(this);
    }
}

