/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.refs;

import java.util.Objects;

public class Reference {
    private final String ref;
    private String abs;
    private String rel;

    public Reference(String ref) {
        if (ref == null) {
            throw new IllegalArgumentException();
        }
        this.ref = ref;
        String[] parts = ref.split("#");
        if (parts.length == 0) {
            this.abs = ref;
            this.rel = null;
        } else if (parts.length == 2) {
            this.abs = "".equals(parts[0]) ? null : parts[0];
            this.rel = "#" + parts[1];
        } else {
            throw new IllegalArgumentException("Wrong reference format.");
        }
    }

    public Reference(String abs, String rel) {
        this((abs == null ? "" : abs) + rel);
    }

    public String getRef() {
        return this.ref;
    }

    public String getAbsPart() {
        return this.abs;
    }

    public String getRelPart() {
        return this.rel;
    }

    public boolean isRelative() {
        return this.abs == null;
    }

    public String getName() {
        Objects.requireNonNull(this.rel, "No relative part in the reference.");
        String[] parts = this.rel.split("/");
        return parts[parts.length - 1];
    }

    public Reference withAbsoluteFrom(Reference that) {
        if (that.getAbsPart() == null) {
            throw new IllegalArgumentException();
        }
        return new Reference(that.abs + this.rel);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reference reference = (Reference)o;
        return this.ref.equals(reference.ref);
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public String toString() {
        return "Reference [" + this.ref + "]";
    }
}

