/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.transform;

import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Operation;
import io.apicurio.datamodels.models.SecurityRequirement;
import io.apicurio.datamodels.models.Server;
import io.apicurio.datamodels.models.asyncapi.AsyncApiSecurityRequirement;
import io.apicurio.datamodels.models.asyncapi.AsyncApiServer;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20SecurityRequirement;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Server;
import io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21SecurityRequirement;
import io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21Server;
import io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22SecurityRequirement;
import io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22Server;
import io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23SecurityRequirement;
import io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23Server;
import io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24SecurityRequirement;
import io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24Server;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SecurityRequirement;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Server;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26SecurityRequirement;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Server;
import io.apicurio.datamodels.models.openapi.OpenApiDocument;
import io.apicurio.datamodels.models.openapi.OpenApiOperation;
import io.apicurio.datamodels.models.openapi.OpenApiSecurityRequirement;
import io.apicurio.datamodels.models.visitors.CombinedVisitorAdapter;

public class SecurityRequirementCreator
extends CombinedVisitorAdapter {
    SecurityRequirement securityRequirement;

    @Override
    public void visitDocument(Document node) {
        OpenApiDocument doc = (OpenApiDocument)node;
        this.securityRequirement = doc.createSecurityRequirement();
        doc.addSecurity((OpenApiSecurityRequirement)this.securityRequirement);
    }

    @Override
    public void visitServer(Server node) {
        AsyncApiServer server = (AsyncApiServer)node;
        AsyncApiSecurityRequirementParent srp = new AsyncApiSecurityRequirementParent(server);
        this.securityRequirement = srp.createSecurityRequirement();
        srp.addSecurity((AsyncApiSecurityRequirement)this.securityRequirement);
    }

    @Override
    public void visitOperation(Operation node) {
        OpenApiOperation op = (OpenApiOperation)node;
        this.securityRequirement = op.createSecurityRequirement();
        op.addSecurity((OpenApiSecurityRequirement)this.securityRequirement);
    }

    private class AsyncApiSecurityRequirementParent {
        AsyncApiServer server;

        private AsyncApiSecurityRequirementParent(AsyncApiServer server) {
            this.server = server;
        }

        public AsyncApiSecurityRequirement createSecurityRequirement() {
            if (this.server instanceof AsyncApi20Server) {
                return ((AsyncApi20Server)this.server).createSecurityRequirement();
            }
            if (this.server instanceof AsyncApi21Server) {
                return ((AsyncApi21Server)this.server).createSecurityRequirement();
            }
            if (this.server instanceof AsyncApi22Server) {
                return ((AsyncApi22Server)this.server).createSecurityRequirement();
            }
            if (this.server instanceof AsyncApi23Server) {
                return ((AsyncApi23Server)this.server).createSecurityRequirement();
            }
            if (this.server instanceof AsyncApi24Server) {
                return ((AsyncApi24Server)this.server).createSecurityRequirement();
            }
            if (this.server instanceof AsyncApi25Server) {
                return ((AsyncApi25Server)this.server).createSecurityRequirement();
            }
            if (this.server instanceof AsyncApi26Server) {
                return ((AsyncApi26Server)this.server).createSecurityRequirement();
            }
            return null;
        }

        public void addSecurity(AsyncApiSecurityRequirement securityRequirement) {
            if (this.server instanceof AsyncApi20Server) {
                ((AsyncApi20Server)this.server).addSecurity((AsyncApi20SecurityRequirement)securityRequirement);
            }
            if (this.server instanceof AsyncApi21Server) {
                ((AsyncApi21Server)this.server).addSecurity((AsyncApi21SecurityRequirement)securityRequirement);
            }
            if (this.server instanceof AsyncApi22Server) {
                ((AsyncApi22Server)this.server).addSecurity((AsyncApi22SecurityRequirement)securityRequirement);
            }
            if (this.server instanceof AsyncApi23Server) {
                ((AsyncApi23Server)this.server).addSecurity((AsyncApi23SecurityRequirement)securityRequirement);
            }
            if (this.server instanceof AsyncApi24Server) {
                ((AsyncApi24Server)this.server).addSecurity((AsyncApi24SecurityRequirement)securityRequirement);
            }
            if (this.server instanceof AsyncApi25Server) {
                ((AsyncApi25Server)this.server).addSecurity((AsyncApi25SecurityRequirement)securityRequirement);
            }
            if (this.server instanceof AsyncApi26Server) {
                ((AsyncApi26Server)this.server).addSecurity((AsyncApi26SecurityRequirement)securityRequirement);
            }
        }
    }
}

