/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.value;

import io.apicurio.datamodels.models.ModelType;
import io.apicurio.datamodels.models.SecurityRequirement;
import io.apicurio.datamodels.models.SecurityScheme;
import io.apicurio.datamodels.models.openapi.OpenApiDocument;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Document;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Document;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.invalid.value.AbstractInvalidPropertyValueRule;
import java.util.ArrayList;
import java.util.List;

public class OasSecurityRequirementScopesMustBeEmptyRule
extends AbstractInvalidPropertyValueRule {
    public OasSecurityRequirementScopesMustBeEmptyRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private SecurityScheme findSecurityScheme(OpenApiDocument document, String schemeName) {
        if (document.root().modelType() == ModelType.OPENAPI20) {
            OpenApi20Document doc20 = (OpenApi20Document)document;
            if (this.hasValue(doc20.getSecurityDefinitions())) {
                return (SecurityScheme)doc20.getSecurityDefinitions().getItem(schemeName);
            }
        } else {
            OpenApi30Document doc30 = (OpenApi30Document)document;
            if (this.hasValue(doc30.getComponents()) && this.hasValue(doc30.getComponents().getSecuritySchemes())) {
                return doc30.getComponents().getSecuritySchemes().get(schemeName);
            }
        }
        return null;
    }

    @Override
    public void visitSecurityRequirement(SecurityRequirement node) {
        ArrayList<String> allowedTypes = new ArrayList<String>();
        allowedTypes.add("oauth2");
        String options = "\"oauth2\"";
        if (node.root().modelType() == ModelType.OPENAPI30) {
            allowedTypes.add("openIdConnect");
            options = "\"oauth2\" or \"openIdConnect\"";
        }
        List<String> snames = node.getItemNames();
        for (String sname : snames) {
            SecurityScheme scheme = this.findSecurityScheme((OpenApiDocument)((Object)node.root()), sname);
            if (!this.hasValue(scheme) || allowedTypes.indexOf(scheme.getType()) != -1) continue;
            List<String> scopes = this.getScopes(node, sname);
            this.reportIfInvalid(this.hasValue(scopes) && scopes.size() == 0, node, null, this.map("sname", sname, "options", options));
        }
    }

    private List<String> getScopes(SecurityRequirement node, String sname) {
        return (List)node.getItem(sname);
    }
}

