/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.models.io;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.models.ModelType;
import io.apicurio.datamodels.models.asyncapi.v20.io.AsyncApi20ModelReader;
import io.apicurio.datamodels.models.asyncapi.v20.io.AsyncApi20ModelReaderDispatcher;
import io.apicurio.datamodels.models.asyncapi.v21.io.AsyncApi21ModelReader;
import io.apicurio.datamodels.models.asyncapi.v21.io.AsyncApi21ModelReaderDispatcher;
import io.apicurio.datamodels.models.asyncapi.v22.io.AsyncApi22ModelReader;
import io.apicurio.datamodels.models.asyncapi.v22.io.AsyncApi22ModelReaderDispatcher;
import io.apicurio.datamodels.models.asyncapi.v23.io.AsyncApi23ModelReader;
import io.apicurio.datamodels.models.asyncapi.v23.io.AsyncApi23ModelReaderDispatcher;
import io.apicurio.datamodels.models.asyncapi.v24.io.AsyncApi24ModelReader;
import io.apicurio.datamodels.models.asyncapi.v24.io.AsyncApi24ModelReaderDispatcher;
import io.apicurio.datamodels.models.asyncapi.v25.io.AsyncApi25ModelReader;
import io.apicurio.datamodels.models.asyncapi.v25.io.AsyncApi25ModelReaderDispatcher;
import io.apicurio.datamodels.models.asyncapi.v26.io.AsyncApi26ModelReader;
import io.apicurio.datamodels.models.asyncapi.v26.io.AsyncApi26ModelReaderDispatcher;
import io.apicurio.datamodels.models.asyncapi.v30.io.AsyncApi30ModelReader;
import io.apicurio.datamodels.models.asyncapi.v30.io.AsyncApi30ModelReaderDispatcher;
import io.apicurio.datamodels.models.io.ModelReader;
import io.apicurio.datamodels.models.openapi.v20.io.OpenApi20ModelReader;
import io.apicurio.datamodels.models.openapi.v20.io.OpenApi20ModelReaderDispatcher;
import io.apicurio.datamodels.models.openapi.v30.io.OpenApi30ModelReader;
import io.apicurio.datamodels.models.openapi.v30.io.OpenApi30ModelReaderDispatcher;
import io.apicurio.datamodels.models.openapi.v31.io.OpenApi31ModelReader;
import io.apicurio.datamodels.models.openapi.v31.io.OpenApi31ModelReaderDispatcher;
import io.apicurio.datamodels.models.visitors.Visitor;

public class ModelReaderFactory {
    public static ModelReader createModelReader(ModelType modelType) {
        ModelReader reader = null;
        switch (modelType) {
            case ASYNCAPI23: {
                reader = new AsyncApi23ModelReader();
                break;
            }
            case ASYNCAPI22: {
                reader = new AsyncApi22ModelReader();
                break;
            }
            case ASYNCAPI26: {
                reader = new AsyncApi26ModelReader();
                break;
            }
            case OPENAPI30: {
                reader = new OpenApi30ModelReader();
                break;
            }
            case OPENAPI31: {
                reader = new OpenApi31ModelReader();
                break;
            }
            case ASYNCAPI30: {
                reader = new AsyncApi30ModelReader();
                break;
            }
            case OPENAPI20: {
                reader = new OpenApi20ModelReader();
                break;
            }
            case ASYNCAPI20: {
                reader = new AsyncApi20ModelReader();
                break;
            }
            case ASYNCAPI25: {
                reader = new AsyncApi25ModelReader();
                break;
            }
            case ASYNCAPI21: {
                reader = new AsyncApi21ModelReader();
                break;
            }
            case ASYNCAPI24: {
                reader = new AsyncApi24ModelReader();
            }
        }
        return reader;
    }

    public static Visitor createModelReaderDispatcher(ModelType modelType, ObjectNode json) {
        ModelReader reader = ModelReaderFactory.createModelReader(modelType);
        Visitor visitor = null;
        switch (modelType) {
            case ASYNCAPI23: {
                visitor = new AsyncApi23ModelReaderDispatcher(json, (AsyncApi23ModelReader)reader);
                break;
            }
            case ASYNCAPI22: {
                visitor = new AsyncApi22ModelReaderDispatcher(json, (AsyncApi22ModelReader)reader);
                break;
            }
            case ASYNCAPI26: {
                visitor = new AsyncApi26ModelReaderDispatcher(json, (AsyncApi26ModelReader)reader);
                break;
            }
            case OPENAPI30: {
                visitor = new OpenApi30ModelReaderDispatcher(json, (OpenApi30ModelReader)reader);
                break;
            }
            case OPENAPI31: {
                visitor = new OpenApi31ModelReaderDispatcher(json, (OpenApi31ModelReader)reader);
                break;
            }
            case ASYNCAPI30: {
                visitor = new AsyncApi30ModelReaderDispatcher(json, (AsyncApi30ModelReader)reader);
                break;
            }
            case OPENAPI20: {
                visitor = new OpenApi20ModelReaderDispatcher(json, (OpenApi20ModelReader)reader);
                break;
            }
            case ASYNCAPI20: {
                visitor = new AsyncApi20ModelReaderDispatcher(json, (AsyncApi20ModelReader)reader);
                break;
            }
            case ASYNCAPI25: {
                visitor = new AsyncApi25ModelReaderDispatcher(json, (AsyncApi25ModelReader)reader);
                break;
            }
            case ASYNCAPI21: {
                visitor = new AsyncApi21ModelReaderDispatcher(json, (AsyncApi21ModelReader)reader);
                break;
            }
            case ASYNCAPI24: {
                visitor = new AsyncApi24ModelReaderDispatcher(json, (AsyncApi24ModelReader)reader);
            }
        }
        return visitor;
    }
}

