/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.paths;

import io.apicurio.datamodels.paths.NodePathSegment;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class NodePath {
    private final List<NodePathSegment> segments = new LinkedList<NodePathSegment>();
    private static final int SCAN_TYPE_PATH = 0;
    private static final int SCAN_TYPE_INDEX = 1;

    public void append(NodePathSegment segment) {
        this.segments.add(segment);
    }

    public void prepend(NodePathSegment segment) {
        this.segments.add(0, segment);
    }

    public List<NodePathSegment> getSegments() {
        return this.segments;
    }

    public NodePathSegment getLastSegment() {
        if (this.segments.size() > 0) {
            return this.segments.get(this.segments.size() - 1);
        }
        return null;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean escaped) {
        StringBuilder builder = new StringBuilder();
        if (this.segments.size() > 0) {
            this.segments.forEach(segment -> builder.append(segment.toString(escaped)));
        } else {
            builder.append("/");
        }
        return builder.toString();
    }

    public List<String> toSegments() {
        ArrayList<String> rval = new ArrayList<String>();
        for (NodePathSegment segment : this.segments) {
            rval.add(segment.toString());
        }
        return rval;
    }

    public static NodePath parse(String path) {
        NodePath rval = null;
        if ("/".equals(path)) {
            rval = new NodePath();
        } else if (path != null && path.indexOf("/") == 0) {
            rval = new NodePath();
            boolean currentScanType = false;
            int currentIdx = 1;
            while (currentIdx < path.length()) {
                int segEnd;
                int segStart = currentIdx;
                if (!currentScanType) {
                    int nextPathSep = path.indexOf("/", segStart);
                    int nextBrace = path.indexOf("[", segStart);
                    if (nextPathSep == -1) {
                        nextPathSep = path.length();
                    }
                    if (nextBrace == -1) {
                        nextBrace = path.length();
                    }
                    segEnd = nextPathSep <= nextBrace ? nextPathSep : nextBrace;
                } else {
                    int nextCloseBrace = path.indexOf("]", segStart);
                    if (nextCloseBrace == -1) {
                        nextCloseBrace = path.length();
                    }
                    segEnd = nextCloseBrace + 1;
                }
                String seg = path.substring(segStart, segEnd);
                NodePathSegment segment = NodePathSegment.parse(seg);
                rval.append(segment);
                currentScanType = false;
                currentIdx = segEnd + 1;
                if (segEnd >= path.length()) continue;
                if (path.charAt(segEnd) == '/') {
                    currentScanType = false;
                    currentIdx = segEnd + 1;
                    continue;
                }
                if (path.charAt(segEnd) == '[') {
                    currentScanType = true;
                    currentIdx = segEnd;
                    continue;
                }
                if (path.charAt(segEnd) != ']') continue;
                if (path.charAt(segEnd + 1) == '[') {
                    currentScanType = true;
                    currentIdx = segEnd + 1;
                    continue;
                }
                if (path.charAt(segEnd + 1) != '/') continue;
                currentScanType = false;
                currentIdx = segEnd + 1;
            }
        }
        return rval;
    }
}

